/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.OAuthErrorDetails;
import com.microsoft.bingads.OAuthTokenRequestException;
import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.HttpClientWebServiceCaller;
import com.microsoft.bingads.internal.OAuthEndpointHelper;
import com.microsoft.bingads.internal.OAuthErrorDetailsContract;
import com.microsoft.bingads.internal.OAuthRequestParameters;
import com.microsoft.bingads.internal.OAuthService;
import com.microsoft.bingads.internal.OAuthTokensContract;
import com.microsoft.bingads.internal.WebServiceCaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.helpers.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class UriOAuthService
implements OAuthService {
    private final WebServiceCaller webServiceCaller;
    private ObjectMapper mapper;
    private ApiEnvironment environment;

    public UriOAuthService(ApiEnvironment env) {
        this(new HttpClientWebServiceCaller(), env);
    }

    public UriOAuthService(WebServiceCaller caller, ApiEnvironment env) {
        this.webServiceCaller = caller;
        this.mapper = new ObjectMapper();
        this.environment = env;
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public OAuthTokens getAccessTokens(OAuthRequestParameters oAuthParameters, boolean requireLiveConnect) {
        try {
            List<NameValuePair> paramsList = UriOAuthService.generateParamsList(oAuthParameters, requireLiveConnect);
            HttpResponse httpResponse = this.webServiceCaller.post(new URL(OAuthEndpointHelper.getOauthEndpoint(this.environment, requireLiveConnect).getTokenRequestUrl()), paramsList);
            InputStream stream = httpResponse.getEntity().getContent();
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)stream, (OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                OAuthTokensContract oauthResponse = (OAuthTokensContract)this.mapper.readValue(bytes, OAuthTokensContract.class);
                JsonNode root = this.mapper.readTree(bytes);
                OAuthTokens oAuthTokens = new OAuthTokens(oauthResponse.getAccessToken(), oauthResponse.getAccessTokenExpiresInSeconds(), oauthResponse.getRefreshToken(), root);
                return oAuthTokens;
            }
            try {
                OAuthErrorDetailsContract errorResponse = (OAuthErrorDetailsContract)this.mapper.readValue(stream, OAuthErrorDetailsContract.class);
                OAuthErrorDetails errorDetails = new OAuthErrorDetails(errorResponse.getError(), errorResponse.getDescription());
                throw new OAuthTokenRequestException("Couldn't request OAuth AccessTokens. Please use the getDetails() method to get more information", errorDetails);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        finally {
            this.webServiceCaller.shutDown();
        }
    }

    private static List<NameValuePair> generateParamsList(OAuthRequestParameters requestParams, boolean requireLiveConnect) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("client_id", requestParams.getClientId()));
        if (requestParams.getClientSecret() != null && !requestParams.getClientSecret().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair("client_secret", requestParams.getClientSecret()));
        }
        params.add((NameValuePair)new BasicNameValuePair("grant_type", requestParams.getGrantType()));
        params.add((NameValuePair)new BasicNameValuePair(requestParams.getGrantParamName(), requestParams.getGrantValue()));
        if (requestParams.getRedirectionUri() != null) {
            params.add((NameValuePair)new BasicNameValuePair("redirect_uri", requestParams.getRedirectionUri().toString()));
        }
        params.add((NameValuePair)new BasicNameValuePair("scope", requireLiveConnect ? "bingads.manage" : "https://ads.microsoft.com/ads.manage offline_access"));
        return params;
    }

    @Override
    public URL getRedirectUrl(boolean requireLiveConnect) {
        return OAuthEndpointHelper.getOauthEndpoint(this.environment, requireLiveConnect).getDesktopRedirectUrl();
    }

    private static enum HttpMethods {
        POST;

    }
}

