/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QualityScoreData {
    private Integer qualityScore;
    private Integer keywordRelevance;
    private Integer landingPageRelevance;
    private Integer landingPageUserExperience;
    private static final List<BulkMapping<QualityScoreData>> MAPPINGS;

    public Integer getLandingPageUserExperience() {
        return this.landingPageUserExperience;
    }

    private void setLandingPageUserExperience(Integer landingPageUserExperience) {
        this.landingPageUserExperience = landingPageUserExperience;
    }

    public Integer getQualityScore() {
        return this.qualityScore;
    }

    private void setQualityScore(Integer qualityScore) {
        this.qualityScore = qualityScore;
    }

    public Integer getKeywordRelevance() {
        return this.keywordRelevance;
    }

    private void setKeywordRelevance(Integer keywordRelevance) {
        this.keywordRelevance = keywordRelevance;
    }

    public Integer getLandingPageRelevance() {
        return this.landingPageRelevance;
    }

    private void setLandingPageRelevance(Integer landingPageRelevance) {
        this.landingPageRelevance = landingPageRelevance;
    }

    static QualityScoreData readFromRowValuesOrNull(RowValues values) {
        QualityScoreData qualityScoreData = new QualityScoreData();
        qualityScoreData.readFromRowValues(values);
        return qualityScoreData.hasAnyValues() ? qualityScoreData : null;
    }

    static void writeToRowValuesIfNotNull(QualityScoreData qualityScoreData, RowValues values) {
        if (qualityScoreData != null) {
            qualityScoreData.writeToRowValues(values);
        }
    }

    private boolean hasAnyValues() {
        return this.qualityScore != null || this.keywordRelevance != null || this.landingPageRelevance != null || this.landingPageUserExperience != null;
    }

    void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    void writeToRowValues(RowValues values) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<QualityScoreData, Integer>> m = new ArrayList<SimpleBulkMapping<QualityScoreData, Integer>>();
        m.add(new SimpleBulkMapping<QualityScoreData, Integer>("Quality Score", new Function<QualityScoreData, Integer>(){

            @Override
            public Integer apply(QualityScoreData t) {
                return t.getQualityScore();
            }
        }, new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setQualityScore(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<QualityScoreData, Integer>("Keyword Relevance", new Function<QualityScoreData, Integer>(){

            @Override
            public Integer apply(QualityScoreData t) {
                return t.getKeywordRelevance();
            }
        }, new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setKeywordRelevance(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<QualityScoreData, Integer>("Landing Page Relevance", new Function<QualityScoreData, Integer>(){

            @Override
            public Integer apply(QualityScoreData t) {
                return t.getLandingPageRelevance();
            }
        }, new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setLandingPageRelevance(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<QualityScoreData, Integer>("Landing Page User Experience", new Function<QualityScoreData, Integer>(){

            @Override
            public Integer apply(QualityScoreData t) {
                return t.getLandingPageUserExperience();
            }
        }, new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setLandingPageUserExperience(StringExtensions.parseOptionalInteger(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

