/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeSimilarRemarketingListAssociation
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String remarketingListName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        adGroupCriterion.setType(NegativeAdGroupCriterion.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), "AdGroupRemarketingListAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion adGroupCriterion) {
        this.negativeAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getRemarketingListName() {
        return this.remarketingListName;
    }

    public void setRemarketingListName(String remarketingListName) {
        this.remarketingListName = remarketingListName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>("Status", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>("Id", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>("Parent Id", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>("Campaign", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>("Ad Group", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>("Audience", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                return c.getRemarketingListName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                c.setRemarketingListName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>("Audience Id", new Function<BulkAdGroupNegativeSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                if (c.getNegativeAdGroupCriterion() instanceof NegativeAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeSimilarRemarketingListAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

