/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.BulkAd;
import com.microsoft.bingads.v11.campaignmanagement.AdType;
import com.microsoft.bingads.v11.campaignmanagement.ExpandedTextAd;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkExpandedTextAd
extends BulkAd<ExpandedTextAd> {
    private static final List<BulkMapping<BulkExpandedTextAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getExpandedTextAd(), "ExpandedTextAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new ExpandedTextAd());
        ((ExpandedTextAd)this.getAd()).setType(AdType.EXPANDED_TEXT);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public ExpandedTextAd getExpandedTextAd() {
        return (ExpandedTextAd)this.ad;
    }

    public void setExpandedTextAd(ExpandedTextAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkExpandedTextAd, String>> m = new ArrayList<SimpleBulkMapping<BulkExpandedTextAd, String>>();
        m.add(new SimpleBulkMapping<BulkExpandedTextAd, String>("Title Part 1", new Function<BulkExpandedTextAd, String>(){

            @Override
            public String apply(BulkExpandedTextAd c) {
                return ((ExpandedTextAd)c.getAd()).getTitlePart1();
            }
        }, new BiConsumer<String, BulkExpandedTextAd>(){

            @Override
            public void accept(String v, BulkExpandedTextAd c) {
                ((ExpandedTextAd)c.getAd()).setTitlePart1(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkExpandedTextAd, String>("Title Part 2", new Function<BulkExpandedTextAd, String>(){

            @Override
            public String apply(BulkExpandedTextAd c) {
                return ((ExpandedTextAd)c.getAd()).getTitlePart2();
            }
        }, new BiConsumer<String, BulkExpandedTextAd>(){

            @Override
            public void accept(String v, BulkExpandedTextAd c) {
                ((ExpandedTextAd)c.getAd()).setTitlePart2(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkExpandedTextAd, String>("Text", new Function<BulkExpandedTextAd, String>(){

            @Override
            public String apply(BulkExpandedTextAd c) {
                return ((ExpandedTextAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkExpandedTextAd>(){

            @Override
            public void accept(String v, BulkExpandedTextAd c) {
                ((ExpandedTextAd)c.getAd()).setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkExpandedTextAd, String>("Path 1", new Function<BulkExpandedTextAd, String>(){

            @Override
            public String apply(BulkExpandedTextAd c) {
                return ((ExpandedTextAd)c.getAd()).getPath1();
            }
        }, new BiConsumer<String, BulkExpandedTextAd>(){

            @Override
            public void accept(String v, BulkExpandedTextAd c) {
                ((ExpandedTextAd)c.getAd()).setPath1(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkExpandedTextAd, String>("Path 2", new Function<BulkExpandedTextAd, String>(){

            @Override
            public String apply(BulkExpandedTextAd c) {
                return ((ExpandedTextAd)c.getAd()).getPath2();
            }
        }, new BiConsumer<String, BulkExpandedTextAd>(){

            @Override
            public void accept(String v, BulkExpandedTextAd c) {
                ((ExpandedTextAd)c.getAd()).setPath2(v);
            }
        }, true));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

