/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import com.googlecode.jcsv.writer.CSVWriter;
import com.googlecode.jcsv.writer.internal.CSVWriterBuilder;
import com.microsoft.bingads.v10.bulk.DownloadFileType;
import com.microsoft.bingads.v10.bulk.entities.StaticBulkObjectFactory;
import com.microsoft.bingads.v10.internal.bulk.BulkObject;
import com.microsoft.bingads.v10.internal.bulk.BulkObjectFactory;
import com.microsoft.bingads.v10.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v10.internal.bulk.CsvHeaders;
import com.microsoft.bingads.v10.internal.bulk.ReplaceNullsWithEmptyStringCSVEntryConverter;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class SimpleBulkObjectWriter
implements BulkObjectWriter {
    private BulkObjectFactory bulkObjectFactory = new StaticBulkObjectFactory();
    private CSVWriter<String[]> csvWriter;
    private Writer writer;

    public SimpleBulkObjectWriter(File filePath, DownloadFileType fileFormat) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
        this.csvWriter = this.buildCSVWriter(this.writer, fileFormat == DownloadFileType.CSV ? (char)',' : '\t');
    }

    @Override
    public void writeFileMetadata() throws IOException {
        this.writeHeaders();
        this.writeFormatVersion();
    }

    private void writeFormatVersion() throws IOException {
        RowValues versionRow = new RowValues();
        versionRow.put("Type", "Format Version");
        versionRow.put("Name", "4.0");
        this.csvWriter.write((Object)versionRow.getColumns());
    }

    private void writeHeaders() throws IOException {
        this.writer.write(65279);
        this.csvWriter.write((Object)CsvHeaders.Headers);
        this.csvWriter.flush();
    }

    private CSVWriter<String[]> buildCSVWriter(Writer writer, char delimiter) {
        return new CSVWriterBuilder(writer).entryConverter((CSVEntryConverter)new ReplaceNullsWithEmptyStringCSVEntryConverter()).strategy(this.createStrategyWithDelimiter(delimiter)).build();
    }

    private CSVStrategy createStrategyWithDelimiter(char delimiter) {
        return new CSVStrategy(delimiter, '\"', '#', false, true);
    }

    @Override
    public void writeObjectRow(BulkObject bulkObject, boolean excludeReadonlyData) throws IOException {
        RowValues values = new RowValues();
        bulkObject.writeToRowValues(values, excludeReadonlyData);
        String type = this.bulkObjectFactory.getBulkRowType(bulkObject);
        values.put("Type", type);
        this.csvWriter.write((Object)values.getColumns());
        this.csvWriter.flush();
    }

    @Override
    public void writeObjectRow(BulkObject bulkObject) throws IOException {
        this.writeObjectRow(bulkObject, false);
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

