/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.internal.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkEntityIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdExtensionIdentifier
extends BulkEntityIdentifier {
    private Long accountId;
    private Long adExtensionId;
    private AdExtensionStatus status;
    private Integer version;
    private static List<BulkMapping<BulkAdExtensionIdentifier>> MAPPINGS;

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAdExtensionId() {
        return this.adExtensionId;
    }

    public void setAdExtensionId(Long adExtensionId) {
        this.adExtensionId = adExtensionId;
    }

    public AdExtensionStatus getStatus() {
        return this.status;
    }

    public void setStatus(AdExtensionStatus status) {
        this.status = status;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public void writeToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public boolean isDeleteRow() {
        return AdExtensionStatus.DELETED.equals((Object)this.status);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdExtensionIdentifier, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdExtensionIdentifier, Object>>();
        m.add(new SimpleBulkMapping<BulkAdExtensionIdentifier, Long>("Id", new Function<BulkAdExtensionIdentifier, Long>(){

            @Override
            public Long apply(BulkAdExtensionIdentifier c) {
                return c.getAdExtensionId();
            }
        }, new BiConsumer<String, BulkAdExtensionIdentifier>(){

            @Override
            public void accept(String v, BulkAdExtensionIdentifier c) {
                c.setAdExtensionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionIdentifier, Long>("Parent Id", new Function<BulkAdExtensionIdentifier, Long>(){

            @Override
            public Long apply(BulkAdExtensionIdentifier c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkAdExtensionIdentifier>(){

            @Override
            public void accept(String v, BulkAdExtensionIdentifier c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionIdentifier, String>("Status", new Function<BulkAdExtensionIdentifier, String>(){

            @Override
            public String apply(BulkAdExtensionIdentifier c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdExtensionIdentifier>(){

            @Override
            public void accept(String v, BulkAdExtensionIdentifier c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, AdExtensionStatus>(){

                    @Override
                    public AdExtensionStatus apply(String value) {
                        return AdExtensionStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionIdentifier, Integer>("Version", new Function<BulkAdExtensionIdentifier, Integer>(){

            @Override
            public Integer apply(BulkAdExtensionIdentifier c) {
                return c.getVersion();
            }
        }, new BiConsumer<String, BulkAdExtensionIdentifier>(){

            @Override
            public void accept(String v, BulkAdExtensionIdentifier c) {
                c.setVersion(StringExtensions.parseOptionalInteger(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

