/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v11.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v11.campaignmanagement.Sitelink2AdExtension;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSitelink2AdExtension
extends BulkAdExtension<Sitelink2AdExtension> {
    private static final List<BulkMapping<BulkSitelink2AdExtension>> MAPPINGS;

    public Sitelink2AdExtension getSitelink2AdExtension() {
        return (Sitelink2AdExtension)this.getAdExtension();
    }

    public void setSitelink2AdExtension(Sitelink2AdExtension sitelink2AdExtension) {
        this.setAdExtension(sitelink2AdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        Sitelink2AdExtension extension = new Sitelink2AdExtension();
        extension.setType("Sitelink2AdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdExtension(), "Sitelink2AdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSitelink2AdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkSitelink2AdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Sitelink Extension Destination Url", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.toOptionalBulkString(c.getSitelink2AdExtension().getDestinationUrl());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                c.getSitelink2AdExtension().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Sitelink Extension Description1", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return c.getSitelink2AdExtension().getDescription1();
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                c.getSitelink2AdExtension().setDescription1(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Sitelink Extension Description2", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return c.getSitelink2AdExtension().getDescription2();
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                c.getSitelink2AdExtension().setDescription2(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Device Preference", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.toDevicePreferenceBulkString(((Sitelink2AdExtension)c.getAdExtension()).getDevicePreference());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                ((Sitelink2AdExtension)c.getAdExtension()).setDevicePreference(StringExtensions.parseDevicePreference(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Sitelink Extension Link Text", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return c.getSitelink2AdExtension().getDisplayText();
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                c.getSitelink2AdExtension().setDisplayText(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Final Url", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.writeUrls("; ", ((Sitelink2AdExtension)c.getAdExtension()).getFinalUrls());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((Sitelink2AdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Mobile Final Url", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.writeUrls("; ", ((Sitelink2AdExtension)c.getAdExtension()).getFinalMobileUrls());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((Sitelink2AdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Tracking Template", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.toOptionalBulkString(((Sitelink2AdExtension)c.getAdExtension()).getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                ((Sitelink2AdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelink2AdExtension, String>("Custom Parameter", new Function<BulkSitelink2AdExtension, String>(){

            @Override
            public String apply(BulkSitelink2AdExtension c) {
                return StringExtensions.toCustomParaBulkString(((Sitelink2AdExtension)c.getAdExtension()).getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkSitelink2AdExtension>(){

            @Override
            public void accept(String v, BulkSitelink2AdExtension c) {
                try {
                    ((Sitelink2AdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

