/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AgeCriterion;
import com.microsoft.bingads.v11.campaignmanagement.AgeRange;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignAgeCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion campaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignAgeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AgeCriterion ageCriterion = new AgeCriterion();
        campaignCriterion.setCriterion(ageCriterion);
        campaignCriterion.getCriterion().setType(AgeCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getCampaignCriterion() {
        return this.campaignCriterion;
    }

    public void setCampaignCriterion(BiddableCampaignCriterion campaignCriterion) {
        this.campaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignAgeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignAgeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, String>("Status", new Function<BulkCampaignAgeCriterion, String>(){

            @Override
            public String apply(BulkCampaignAgeCriterion c) {
                CampaignCriterionStatus status = c.getCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                c.getCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, Long>("Id", new Function<BulkCampaignAgeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignAgeCriterion c) {
                return c.getCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                c.getCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, Long>("Parent Id", new Function<BulkCampaignAgeCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignAgeCriterion c) {
                return c.getCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                c.getCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, String>("Campaign", new Function<BulkCampaignAgeCriterion, String>(){

            @Override
            public String apply(BulkCampaignAgeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, String>("Bid Adjustment", new Function<BulkCampaignAgeCriterion, String>(){

            @Override
            public String apply(BulkCampaignAgeCriterion c) {
                if (c.getCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                if (c.getCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAgeCriterion, String>("Target", new Function<BulkCampaignAgeCriterion, String>(){

            @Override
            public String apply(BulkCampaignAgeCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof AgeCriterion) {
                    AgeRange ageRange = ((AgeCriterion)c.getCampaignCriterion().getCriterion()).getAgeRange();
                    return ageRange == null ? null : ageRange.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignAgeCriterion>(){

            @Override
            public void accept(String v, BulkCampaignAgeCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof AgeCriterion) {
                    ((AgeCriterion)c.getCampaignCriterion().getCriterion()).setAgeRange(StringExtensions.parseOptional(v, new Function<String, AgeRange>(){

                        @Override
                        public AgeRange apply(String s) {
                            return AgeRange.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

