/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.IntentOption;
import com.microsoft.bingads.v11.campaignmanagement.LocationIntentCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupLocationIntentCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupLocationIntentCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        LocationIntentCriterion locationIntentCriterion = new LocationIntentCriterion();
        adGroupCriterion.setCriterion(locationIntentCriterion);
        adGroupCriterion.getCriterion().setType(LocationIntentCriterion.class.getSimpleName());
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, String>("Status", new Function<BulkAdGroupLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationIntentCriterion c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, Long>("Id", new Function<BulkAdGroupLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupLocationIntentCriterion c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, Long>("Parent Id", new Function<BulkAdGroupLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupLocationIntentCriterion c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                c.getAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, String>("Campaign", new Function<BulkAdGroupLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationIntentCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, String>("Ad Group", new Function<BulkAdGroupLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationIntentCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationIntentCriterion, String>("Target", new Function<BulkAdGroupLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationIntentCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    IntentOption intentOption = ((LocationIntentCriterion)c.getAdGroupCriterion().getCriterion()).getIntentOption();
                    return intentOption == null ? null : intentOption.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationIntentCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    ((LocationIntentCriterion)c.getAdGroupCriterion().getCriterion()).setIntentOption(StringExtensions.parseOptional(v, new Function<String, IntentOption>(){

                        @Override
                        public IntentOption apply(String s) {
                            return IntentOption.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

