/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupSimilarRemarketingListAssociation
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String remarketingListName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupSimilarRemarketingListAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        adGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        adGroupCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), "AdGroupRemarketingListAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.biddableAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getRemarketingListName() {
        return this.remarketingListName;
    }

    public void setRemarketingListName(String remarketingListName) {
        this.remarketingListName = remarketingListName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, String>("Status", new Function<BulkAdGroupSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, Long>("Id", new Function<BulkAdGroupSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, Long>("Parent Id", new Function<BulkAdGroupSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, String>("Campaign", new Function<BulkAdGroupSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, String>("Ad Group", new Function<BulkAdGroupSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, String>("Audience", new Function<BulkAdGroupSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                return c.getRemarketingListName();
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                c.setRemarketingListName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, String>("Bid Adjustment", new Function<BulkAdGroupSimilarRemarketingListAssociation, String>(){

            @Override
            public String apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupSimilarRemarketingListAssociation, Long>("Audience Id", new Function<BulkAdGroupSimilarRemarketingListAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupSimilarRemarketingListAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupSimilarRemarketingListAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupSimilarRemarketingListAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

