/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeSite;
import com.microsoft.bingads.v11.bulk.entities.BulkNegativeSites;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupNegativeSites;
import com.microsoft.bingads.v11.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkAdGroupNegativeSitesIdentifier;
import java.util.ArrayList;
import java.util.List;

public class BulkAdGroupNegativeSites
extends BulkNegativeSites<BulkAdGroupNegativeSite, BulkAdGroupNegativeSitesIdentifier> {
    private AdGroupNegativeSites adGroupNegativeSites;
    private String adGroupName;
    private String campaignName;

    public AdGroupNegativeSites getAdGroupNegativeSites() {
        return this.adGroupNegativeSites;
    }

    public void setAdGroupNegativeSites(AdGroupNegativeSites adGroupNegativeSites) {
        this.adGroupNegativeSites = adGroupNegativeSites;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public BulkAdGroupNegativeSites() {
    }

    BulkAdGroupNegativeSites(BulkAdGroupNegativeSite site) {
        super(site, BulkAdGroupNegativeSite.class, BulkAdGroupNegativeSitesIdentifier.class);
        this.setDataFromIdentifier((BulkAdGroupNegativeSitesIdentifier)site.getIdentifier());
    }

    public BulkAdGroupNegativeSites(BulkAdGroupNegativeSitesIdentifier identifier) {
        super(identifier, BulkAdGroupNegativeSite.class, BulkAdGroupNegativeSitesIdentifier.class);
        this.setDataFromIdentifier(identifier);
    }

    private void setDataFromIdentifier(BulkAdGroupNegativeSitesIdentifier identifier) {
        this.adGroupNegativeSites = new AdGroupNegativeSites();
        this.adGroupNegativeSites.setAdGroupId(identifier.getAdGroupId());
        this.adGroupName = identifier.getAdGroupName();
        this.campaignName = identifier.getCampaignName();
    }

    @Override
    protected Iterable<BulkAdGroupNegativeSite> convertApiToBulkNegativeSites() {
        this.validateListNotNullOrEmpty(this.adGroupNegativeSites.getNegativeSites(), "AdGroupNegativeSites.NegativeSites");
        ArrayList<BulkAdGroupNegativeSite> bulkSites = new ArrayList<BulkAdGroupNegativeSite>();
        List<String> negativeSites = this.adGroupNegativeSites.getNegativeSites().getStrings();
        for (String negativeSite : negativeSites) {
            BulkAdGroupNegativeSite bulkSite = new BulkAdGroupNegativeSite();
            if (this.adGroupNegativeSites.getAdGroupId() != null) {
                bulkSite.setAdGroupId(this.adGroupNegativeSites.getAdGroupId());
            }
            bulkSite.setWebsite(negativeSite);
            bulkSite.setAdGroupName(this.getAdGroupName());
            bulkSite.setCampaignName(this.getCampaignName());
            bulkSites.add(bulkSite);
        }
        return bulkSites;
    }

    private void validateListNotNullOrEmpty(ArrayOfstring negativeSites, String propertyName) {
        super.validateListNotNullOrEmpty(negativeSites, negativeSites.getStrings(), propertyName);
    }

    @Override
    protected void reconstructApiObjects() {
        ArrayOfstring websitesArray = new ArrayOfstring();
        for (BulkAdGroupNegativeSite bulkNegativeSite : this.getNegativeSites()) {
            websitesArray.getStrings().add(bulkNegativeSite.getWebsite());
        }
        this.adGroupNegativeSites.setNegativeSites(websitesArray);
    }

    @Override
    protected BulkAdGroupNegativeSitesIdentifier createIdentifier() {
        BulkAdGroupNegativeSitesIdentifier identifier = new BulkAdGroupNegativeSitesIdentifier();
        if (this.adGroupNegativeSites.getAdGroupId() != null) {
            identifier.setAdGroupId(this.adGroupNegativeSites.getAdGroupId());
        }
        identifier.setAdGroupName(this.adGroupName);
        identifier.setCampaignName(this.campaignName);
        return identifier;
    }

    @Override
    protected void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.adGroupNegativeSites, "AdGroupNegativeSites");
    }
}

