/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk;

import com.microsoft.bingads.v11.bulk.DownloadFileType;
import com.microsoft.bingads.v11.bulk.entities.BulkEntity;
import com.microsoft.bingads.v11.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkObjectWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class BulkFileWriter
implements Closeable {
    private BulkObjectWriter bulkObjectWriter;
    private boolean metadataWritten = false;

    public BulkFileWriter(File filePath) throws IOException {
        this(filePath, DownloadFileType.CSV);
    }

    public BulkFileWriter(OutputStream outputStream) throws IOException {
        this.bulkObjectWriter = new SimpleBulkObjectWriter(outputStream, DownloadFileType.CSV);
    }

    public BulkFileWriter(OutputStream outputStream, DownloadFileType fileFormat) throws IOException {
        this.bulkObjectWriter = new SimpleBulkObjectWriter(outputStream, fileFormat);
    }

    public BulkFileWriter(File filePath, DownloadFileType fileFormat) throws IOException {
        this.bulkObjectWriter = new SimpleBulkObjectWriter(filePath, fileFormat);
    }

    public BulkFileWriter(BulkObjectWriter bulkObjectWriter) {
        this.bulkObjectWriter = bulkObjectWriter;
    }

    public void writeEntity(BulkEntity entity, boolean excludeReadonlyData) throws IOException {
        if (!this.metadataWritten) {
            this.bulkObjectWriter.writeFileMetadata();
            this.metadataWritten = true;
        }
        entity.writeToStream(this.bulkObjectWriter, excludeReadonlyData);
    }

    public void writeEntity(BulkEntity entity) throws IOException {
        this.writeEntity(entity, false);
    }

    @Override
    public void close() throws IOException {
        this.bulkObjectWriter.close();
    }
}

