/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.internal.WebServiceCaller;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;

class HttpClientWebServiceCaller
implements WebServiceCaller {
    private DefaultHttpClient client;

    HttpClientWebServiceCaller() {
    }

    @Override
    public HttpResponse post(URL requestUrl, List<NameValuePair> formValues) throws IOException {
        try {
            this.client = this.createHttpClientWithProxy();
            HttpPost httpPost = new HttpPost(requestUrl.toURI());
            UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(formValues, "UTF-8");
            httpPost.setEntity((HttpEntity)requestEntity);
            return this.client.execute((HttpUriRequest)httpPost);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultHttpClient createHttpClientWithProxy() {
        DefaultHttpClient client = new DefaultHttpClient();
        ProxySelector proxySelector = ProxySelector.getDefault();
        client.setRoutePlanner((HttpRoutePlanner)new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), proxySelector));
        return client;
    }

    @Override
    public void shutDown() {
        if (this.client != null) {
            this.client.getConnectionManager().shutdown();
        }
    }
}

