/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.Status;
import com.microsoft.bingads.v12.bulk.entities.WebpageConditionHelper;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfWebpageCondition;
import com.microsoft.bingads.v12.campaignmanagement.NegativeCampaignCriterion;
import com.microsoft.bingads.v12.campaignmanagement.Webpage;
import com.microsoft.bingads.v12.campaignmanagement.WebpageParameter;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeDynamicSearchAdTarget
extends SingleRecordBulkEntity {
    private NegativeCampaignCriterion negativeCampaignCriterion;
    private Status status;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignNegativeDynamicSearchAdTarget>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeCampaignCriterion negativeCampaignCriterion = new NegativeCampaignCriterion();
        Webpage webpage = new Webpage();
        webpage.setParameter(new WebpageParameter());
        negativeCampaignCriterion.setCriterion(webpage);
        negativeCampaignCriterion.setType(NegativeCampaignCriterion.class.getSimpleName());
        negativeCampaignCriterion.getCriterion().setType(Webpage.class.getSimpleName());
        this.setNegativeCampaignCriterion(negativeCampaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeCampaignCriterion(), NegativeCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeCampaignCriterion getNegativeCampaignCriterion() {
        return this.negativeCampaignCriterion;
    }

    public void setNegativeCampaignCriterion(NegativeCampaignCriterion negativeCampaignCriterion) {
        this.negativeCampaignCriterion = negativeCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget, String>("Status", new Function<BulkCampaignNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkCampaignNegativeDynamicSearchAdTarget c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget, Long>("Id", new Function<BulkCampaignNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeDynamicSearchAdTarget c) {
                return c.getNegativeCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                c.getNegativeCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget, Long>("Parent Id", new Function<BulkCampaignNegativeDynamicSearchAdTarget, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeDynamicSearchAdTarget c) {
                return c.getNegativeCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                c.getNegativeCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget, String>("Campaign", new Function<BulkCampaignNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkCampaignNegativeDynamicSearchAdTarget c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget>(new BiConsumer<BulkCampaignNegativeDynamicSearchAdTarget, RowValues>(){

            @Override
            public void accept(BulkCampaignNegativeDynamicSearchAdTarget c, RowValues v) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getNegativeCampaignCriterion().getCriterion()).getParameter();
                    if (webpageParameter == null || webpageParameter.getConditions() == null) {
                        return;
                    }
                    WebpageConditionHelper.addRowValuesFromConditions(webpageParameter.getConditions(), v);
                }
            }
        }, new BiConsumer<RowValues, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(RowValues v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getNegativeCampaignCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setConditions(new ArrayOfWebpageCondition());
                    WebpageConditionHelper.addConditionsFromRowValues(v, webpageParameter.getConditions());
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeDynamicSearchAdTarget, String>("Name", new Function<BulkCampaignNegativeDynamicSearchAdTarget, String>(){

            @Override
            public String apply(BulkCampaignNegativeDynamicSearchAdTarget c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof Webpage) {
                    WebpageParameter webpageParameter = ((Webpage)c.getNegativeCampaignCriterion().getCriterion()).getParameter();
                    return StringExtensions.toCriterionNameBulkString(webpageParameter);
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeDynamicSearchAdTarget>(){

            @Override
            public void accept(String v, BulkCampaignNegativeDynamicSearchAdTarget c) {
                WebpageParameter webpageParameter;
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof Webpage && (webpageParameter = ((Webpage)c.getNegativeCampaignCriterion().getCriterion()).getParameter()) != null) {
                    webpageParameter.setCriterionName(StringExtensions.parseCriterionName(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

