/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.campaignmanagement.GenderCriterion;
import com.microsoft.bingads.v11.campaignmanagement.GenderType;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignGenderCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignGenderCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        GenderCriterion genderCriterion = new GenderCriterion();
        campaignCriterion.setCriterion(genderCriterion);
        campaignCriterion.getCriterion().setType(GenderCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignGenderCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignGenderCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, String>("Status", new Function<BulkCampaignGenderCriterion, String>(){

            @Override
            public String apply(BulkCampaignGenderCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, Long>("Id", new Function<BulkCampaignGenderCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignGenderCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, Long>("Parent Id", new Function<BulkCampaignGenderCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignGenderCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, String>("Campaign", new Function<BulkCampaignGenderCriterion, String>(){

            @Override
            public String apply(BulkCampaignGenderCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, String>("Bid Adjustment", new Function<BulkCampaignGenderCriterion, String>(){

            @Override
            public String apply(BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignGenderCriterion, String>("Target", new Function<BulkCampaignGenderCriterion, String>(){

            @Override
            public String apply(BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof GenderCriterion) {
                    GenderType genderType = ((GenderCriterion)c.getBiddableCampaignCriterion().getCriterion()).getGenderType();
                    return genderType == null ? null : genderType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignGenderCriterion>(){

            @Override
            public void accept(String v, BulkCampaignGenderCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof GenderCriterion) {
                    ((GenderCriterion)c.getBiddableCampaignCriterion().getCriterion()).setGenderType(StringExtensions.parseOptional(v, new Function<String, GenderType>(){

                        @Override
                        public GenderType apply(String s) {
                            return GenderType.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

