/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.campaignmanagement.Day;
import com.microsoft.bingads.v12.campaignmanagement.DayTimeCriterion;
import com.microsoft.bingads.v12.campaignmanagement.Minute;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupDayTimeCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupDayTimeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        DayTimeCriterion daytimeCriterion = new DayTimeCriterion();
        adGroupCriterion.setCriterion(daytimeCriterion);
        adGroupCriterion.getCriterion().setType(DayTimeCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupDayTimeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupDayTimeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("Status", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, Long>("Id", new Function<BulkAdGroupDayTimeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupDayTimeCriterion c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, Long>("Parent Id", new Function<BulkAdGroupDayTimeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupDayTimeCriterion c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("Campaign", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("Ad Group", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("Bid Adjustment", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("Target", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Day day = ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getDay();
                    return day == null ? null : day.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setDay(StringExtensions.parseOptional(v, new Function<String, Day>(){

                        @Override
                        public Day apply(String s) {
                            return Day.fromValue(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("From Hour", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Integer hour = ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getFromHour();
                    return StringExtensions.toBulkString(hour);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setFromHour(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("To Hour", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Integer hour = ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getToHour();
                    return StringExtensions.toBulkString(hour);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setToHour(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("From Minute", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Minute minute = ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getFromMinute();
                    return minute == null ? null : StringExtensions.toMinuteBulkString(minute);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setFromMinute(StringExtensions.parseMinute(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupDayTimeCriterion, String>("To Minute", new Function<BulkAdGroupDayTimeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    Minute minute = ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getToMinute();
                    return minute == null ? null : StringExtensions.toMinuteBulkString(minute);
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupDayTimeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupDayTimeCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof DayTimeCriterion) {
                    ((DayTimeCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setToMinute(StringExtensions.parseMinute(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

