/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroup;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupPrivacyStatus;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupStatus;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfSetting;
import com.microsoft.bingads.v12.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.InheritFromParentBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.Network;
import com.microsoft.bingads.v12.campaignmanagement.TargetSetting;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroup
extends SingleRecordBulkEntity {
    private Long campaignId;
    private String campaignName;
    private AdGroup adGroup;
    private QualityScoreData qualityScoreData;
    private PerformanceData performanceData;
    private boolean isExpired;
    private static final List<BulkMapping<BulkAdGroup>> MAPPINGS;

    private TargetSetting getTargetSetting() {
        if (this.adGroup.getSettings() == null || this.adGroup.getSettings().getSettings().size() == 0) {
            return null;
        }
        TargetSetting[] targetSettings = (TargetSetting[])this.adGroup.getSettings().getSettings().stream().filter(e -> e instanceof TargetSetting).toArray(TargetSetting[]::new);
        if (targetSettings.length == 1) {
            return targetSettings[0];
        }
        return null;
    }

    private static void csvToBiddingScheme(RowValues values, BulkAdGroup c) {
        try {
            String bidStrategyTypeRowValue = values.tryGet("Bid Strategy Type");
            if (bidStrategyTypeRowValue == null) {
                return;
            }
            BiddingScheme biddingScheme = StringExtensions.parseBiddingScheme(bidStrategyTypeRowValue);
            if (biddingScheme == null) {
                return;
            }
            if (biddingScheme instanceof InheritFromParentBiddingScheme) {
                InheritFromParentBiddingScheme inheritFromParentBiddingScheme = new InheritFromParentBiddingScheme();
                inheritFromParentBiddingScheme.setType("InheritFromParent");
                inheritFromParentBiddingScheme.setInheritedBidStrategyType(values.tryGet("Inherited Bid Strategy Type"));
                c.getAdGroup().setBiddingScheme(inheritFromParentBiddingScheme);
            } else {
                c.getAdGroup().setBiddingScheme(biddingScheme);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void biddingSchemeToCsv(BulkAdGroup c, RowValues values) {
        BiddingScheme biddingScheme = c.getAdGroup().getBiddingScheme();
        if (biddingScheme == null) {
            return;
        }
        try {
            values.put("Bid Strategy Type", StringExtensions.toBiddingSchemeBulkString(biddingScheme));
            if (biddingScheme instanceof InheritFromParentBiddingScheme) {
                values.put("Inherited Bid Strategy Type", ((InheritFromParentBiddingScheme)biddingScheme).getInheritedBidStrategyType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAdGroup(new AdGroup());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroup(), "AdGroup");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public AdGroup getAdGroup() {
        return this.adGroup;
    }

    public void setAdGroup(AdGroup adGroup) {
        this.adGroup = adGroup;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public boolean getIsExpired() {
        return this.isExpired;
    }

    private void setIsExpired(boolean isExpired) {
        this.isExpired = isExpired;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroup, Long>("Id", new Function<BulkAdGroup, Long>(){

            @Override
            public Long apply(BulkAdGroup c) {
                return c.getAdGroup().getId();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Status", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                if (c.getIsExpired()) {
                    return "Expired";
                }
                return c.getAdGroup().getStatus() != null ? c.getAdGroup().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                if (v.equals("Expired")) {
                    c.getAdGroup().setStatus(AdGroupStatus.EXPIRED);
                    c.setIsExpired(true);
                } else {
                    c.getAdGroup().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupStatus>(){

                        @Override
                        public AdGroupStatus apply(String value) {
                            return AdGroupStatus.fromValue(value);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, Long>("Parent Id", new Function<BulkAdGroup, Long>(){

            @Override
            public Long apply(BulkAdGroup c) {
                return c.getCampaignId();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Campaign", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Ad Group", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getName();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Start Date", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toDateBulkString(c.getAdGroup().getStartDate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("End Date", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toDateBulkString(c.getAdGroup().getEndDate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Network Distribution", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getNetwork() != null ? c.getAdGroup().getNetwork().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setNetwork(StringExtensions.parseOptional(v, new Function<String, Network>(){

                    @Override
                    public Network apply(String value) {
                        return Network.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Ad Rotation", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toAdRotationBulkString(c.getAdGroup().getAdRotation());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setAdRotation(StringExtensions.parseAdRotation(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Cpc Bid", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toAdGroupBidBulkString(c.getAdGroup().getCpcBid());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setCpcBid(StringExtensions.parseAdGroupBid(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Language", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAdGroup().getLanguage());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setLanguage(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, Integer>("Bid Adjustment", new Function<BulkAdGroup, Integer>(){

            @Override
            public Integer apply(BulkAdGroup c) {
                return c.getAdGroup().getAudienceAdsBidAdjustment();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setAudienceAdsBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Tracking Template", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAdGroup().getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Custom Parameter", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toCustomParaBulkString(c.getAdGroup().getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkAdGroup>(new BiConsumer<BulkAdGroup, RowValues>(){

            @Override
            public void accept(BulkAdGroup c, RowValues v) {
                BulkAdGroup.biddingSchemeToCsv(c, v);
            }
        }, new BiConsumer<RowValues, BulkAdGroup>(){

            @Override
            public void accept(RowValues v, BulkAdGroup c) {
                BulkAdGroup.csvToBiddingScheme(v, c);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Target Setting", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                TargetSetting targetSetting = c.getTargetSetting();
                return targetSetting == null ? null : StringExtensions.toBulkString(targetSetting);
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                TargetSetting targetSetting = StringExtensions.parseTargetSetting(v);
                if (targetSetting == null) {
                    return;
                }
                if (c.getAdGroup().getSettings() == null) {
                    c.getAdGroup().setSettings(new ArrayOfSetting());
                }
                c.getAdGroup().getSettings().getSettings().add(targetSetting);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Privacy Status", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getPrivacyStatus() != null ? c.getAdGroup().getPrivacyStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setPrivacyStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupPrivacyStatus>(){

                    @Override
                    public AdGroupPrivacyStatus apply(String value) {
                        return AdGroupPrivacyStatus.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

