/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.campaignmanagement.EntityScope;
import com.microsoft.bingads.v11.campaignmanagement.InMarketAudience;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkInMarketAudience
extends SingleRecordBulkEntity {
    private InMarketAudience inMarketAudience;
    private Status status;
    private static final List<BulkMapping<BulkInMarketAudience>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setInMarketAudience(new InMarketAudience());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getInMarketAudience(), "InMarketAudience");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public InMarketAudience getInMarketAudience() {
        return this.inMarketAudience;
    }

    public void setInMarketAudience(InMarketAudience inMarketAudience) {
        this.inMarketAudience = inMarketAudience;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkInMarketAudience, Object>> m = new ArrayList<SimpleBulkMapping<BulkInMarketAudience, Object>>();
        m.add(new SimpleBulkMapping<BulkInMarketAudience, String>("Status", new Function<BulkInMarketAudience, String>(){

            @Override
            public String apply(BulkInMarketAudience c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, Long>("Id", new Function<BulkInMarketAudience, Long>(){

            @Override
            public Long apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getId();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, Long>("Parent Id", new Function<BulkInMarketAudience, Long>(){

            @Override
            public Long apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getParentId();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, String>("Audience", new Function<BulkInMarketAudience, String>(){

            @Override
            public String apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getName();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, Long>("Audience Search Size", new Function<BulkInMarketAudience, Long>(){

            @Override
            public Long apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getSearchSize();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setSearchSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, String>("Description", new Function<BulkInMarketAudience, String>(){

            @Override
            public String apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getDescription();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, Integer>("Membership Duration", new Function<BulkInMarketAudience, Integer>(){

            @Override
            public Integer apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getMembershipDuration();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, String>("Scope", new Function<BulkInMarketAudience, String>(){

            @Override
            public String apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getScope() != null ? c.getInMarketAudience().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, Long>("Audience Network Size", new Function<BulkInMarketAudience, Long>(){

            @Override
            public Long apply(BulkInMarketAudience c) {
                return c.getInMarketAudience().getAudienceNetworkSize();
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setAudienceNetworkSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkInMarketAudience, String>("Supported Campaign Types", new Function<BulkInMarketAudience, String>(){

            @Override
            public String apply(BulkInMarketAudience c) {
                return StringExtensions.writeArrayOfstring(c.getInMarketAudience().getSupportedCampaignTypes(), ";");
            }
        }, new BiConsumer<String, BulkInMarketAudience>(){

            @Override
            public void accept(String v, BulkInMarketAudience c) {
                c.getInMarketAudience().setSupportedCampaignTypes(StringExtensions.parseArrayOfString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

