/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.campaignmanagement.ProfileCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdGroupProfileCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String profileName;
    private static final List<BulkMapping<BulkAdGroupProfileCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        ProfileCriterion criterion = new ProfileCriterion();
        this.setProfileType(criterion);
        adGroupCriterion.setCriterion(criterion);
        adGroupCriterion.getCriterion().setType(ProfileCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public abstract void setProfileType(ProfileCriterion var1);

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupProfileCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupProfileCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, String>("Status", new Function<BulkAdGroupProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupProfileCriterion c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, Long>("Id", new Function<BulkAdGroupProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupProfileCriterion c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, Long>("Parent Id", new Function<BulkAdGroupProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupProfileCriterion c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, String>("Campaign", new Function<BulkAdGroupProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupProfileCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, String>("Ad Group", new Function<BulkAdGroupProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupProfileCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, String>("Bid Adjustment", new Function<BulkAdGroupProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupProfileCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, String>("Profile", new Function<BulkAdGroupProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupProfileCriterion c) {
                return c.getProfileName();
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                c.setProfileName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProfileCriterion, Long>("Profile Id", new Function<BulkAdGroupProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupProfileCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    return ((ProfileCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getProfileId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupProfileCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    ((ProfileCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setProfileId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

