/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.PerformanceData;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v11.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeProductAudienceAssociation
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String productAudienceName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupNegativeProductAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        adGroupCriterion.setType(NegativeAdGroupCriterion.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), "AdGroupProductAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion adGroupCriterion) {
        this.negativeAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getProductAudienceName() {
        return this.productAudienceName;
    }

    public void setProductAudienceName(String customAudienceName) {
        this.productAudienceName = customAudienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, String>("Status", new Function<BulkAdGroupNegativeProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, Long>("Id", new Function<BulkAdGroupNegativeProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, Long>("Parent Id", new Function<BulkAdGroupNegativeProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, String>("Campaign", new Function<BulkAdGroupNegativeProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, String>("Ad Group", new Function<BulkAdGroupNegativeProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, String>("Audience", new Function<BulkAdGroupNegativeProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                return c.getProductAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                c.setProductAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProductAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupNegativeProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProductAudienceAssociation c) {
                if (c.getNegativeAdGroupCriterion() instanceof NegativeAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProductAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getNegativeAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

