/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.internal.bulk;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.reader.CSVEntryParser;
import com.googlecode.jcsv.reader.CSVReader;
import com.googlecode.jcsv.reader.internal.CSVReaderBuilder;
import com.googlecode.jcsv.reader.internal.DefaultCSVEntryParser;
import com.microsoft.bingads.v12.bulk.entities.StaticBulkObjectFactory;
import com.microsoft.bingads.v12.internal.bulk.BulkObject;
import com.microsoft.bingads.v12.internal.bulk.BulkObjectFactory;
import com.microsoft.bingads.v12.internal.bulk.BulkObjectReader;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SimpleBulkObjectReader
implements BulkObjectReader {
    private BulkObjectFactory bulkObjectFactory;
    private Iterator<String[]> objectIterator;
    private Map<String, Integer> columnMapping;
    private CSVReader<String[]> csvReader;
    private boolean headersInitialized = false;

    public SimpleBulkObjectReader(File file, char delimiter) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")), new StaticBulkObjectFactory(), delimiter);
    }

    public SimpleBulkObjectReader(InputStream inputStream, char delimiter) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")), new StaticBulkObjectFactory(), delimiter);
    }

    public SimpleBulkObjectReader(Reader reader, BulkObjectFactory factory, char delimiter) throws FileNotFoundException {
        this(SimpleBulkObjectReader.buildCSVReader(reader, delimiter), factory);
    }

    public SimpleBulkObjectReader(CSVReader<String[]> csvReader, BulkObjectFactory factory) throws FileNotFoundException {
        this.csvReader = csvReader;
        this.objectIterator = csvReader.iterator();
        this.bulkObjectFactory = factory;
    }

    private Map<String, Integer> generateColumnMapping(String[] headers) {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            mapping.put(headers[i], i);
        }
        return mapping;
    }

    private static CSVReader<String[]> buildCSVReader(Reader reader, char delimiter) {
        try {
            reader.mark(1);
            int read = reader.read();
            if (read != 65279) {
                reader.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CSVReaderBuilder(reader).entryParser((CSVEntryParser)new DefaultCSVEntryParser()).strategy(SimpleBulkObjectReader.createStrategyWithDelimiter(delimiter)).build();
    }

    private static CSVStrategy createStrategyWithDelimiter(char delimiter) {
        return new CSVStrategy(delimiter, '\"', '#', false, true);
    }

    @Override
    public BulkObject readNextBulkObject() {
        this.initializeHeadersIfNeeded();
        if (!this.objectIterator.hasNext()) {
            return null;
        }
        String[] fields = this.objectIterator.next();
        RowValues values = new RowValues(fields, this.columnMapping);
        BulkObject obj = this.bulkObjectFactory.createBulkObject(values);
        obj.readFromRowValues(values);
        return obj;
    }

    private void initializeHeadersIfNeeded() {
        if (!this.headersInitialized) {
            if (this.objectIterator.hasNext()) {
                String[] headers = this.objectIterator.next();
                this.columnMapping = this.generateColumnMapping(headers);
            }
            this.headersInitialized = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.initializeHeadersIfNeeded();
        return this.objectIterator.hasNext();
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }

    @Override
    public BulkObject next() {
        return this.readNextBulkObject();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

