/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.PerformanceData;
import com.microsoft.bingads.v10.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfSetting;
import com.microsoft.bingads.v10.campaignmanagement.BudgetLimitType;
import com.microsoft.bingads.v10.campaignmanagement.Campaign;
import com.microsoft.bingads.v10.campaignmanagement.CampaignStatus;
import com.microsoft.bingads.v10.campaignmanagement.CampaignType;
import com.microsoft.bingads.v10.campaignmanagement.Setting;
import com.microsoft.bingads.v10.campaignmanagement.ShoppingSetting;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import com.microsoft.bingads.v10.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BulkCampaign
extends SingleRecordBulkEntity {
    private Long accountId;
    private Campaign campaign;
    private QualityScoreData qualityScoreData;
    private PerformanceData performanceData;
    private String budgetName;
    private static final List<BulkMapping<BulkCampaign>> MAPPINGS;
    private static BiConsumer<BulkCampaign, RowValues> budgetToCsv;
    private static BiConsumer<RowValues, BulkCampaign> csvToBudget;

    private static List<Setting> filterSettings(List<Setting> settings, CampaignType campaignType) {
        ArrayList<Setting> filteredSettings = new ArrayList<Setting>();
        for (Setting setting : settings) {
            if (campaignType != CampaignType.SHOPPING || !(setting instanceof ShoppingSetting)) continue;
            filteredSettings.add(setting);
        }
        return filteredSettings;
    }

    private ShoppingSetting getShoppingSetting() {
        if (this.getCampaign().getSettings() == null) {
            return null;
        }
        List<Setting> shoppingSettings = BulkCampaign.filterSettings(this.getCampaign().getSettings().getSettings(), CampaignType.SHOPPING);
        if (shoppingSettings.size() != 1) {
            throw new IllegalArgumentException("Can only have 1 ShoppingSetting in Campaign Settings.");
        }
        return (ShoppingSetting)shoppingSettings.get(0);
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCampaign(new Campaign());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaign(), "Campaign");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public static boolean isDailyBudget(BudgetLimitType budgetType) {
        return BudgetLimitType.DAILY_BUDGET_ACCELERATED.equals((Object)budgetType) || BudgetLimitType.DAILY_BUDGET_STANDARD.equals((Object)budgetType);
    }

    static {
        budgetToCsv = new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                BudgetLimitType budgetType = c.getCampaign().getBudgetType();
                if (budgetType == null) {
                    return;
                }
                Double budget = BulkCampaign.isDailyBudget(budgetType) ? c.getCampaign().getDailyBudget() : c.getCampaign().getMonthlyBudget();
                if (budget == null) {
                    return;
                }
                values.put("Budget", budget.toString());
            }
        };
        csvToBudget = new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                String budgetTypeRowValue = values.get("Budget Type");
                BudgetLimitType budgetType = StringExtensions.parseOptional(budgetTypeRowValue, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                });
                if (budgetType == null) {
                    return;
                }
                String budgetRowValue = values.get("Budget");
                if (budgetRowValue == null) {
                    return;
                }
                Double budgetValue = StringExtensions.nullOrDouble(budgetRowValue);
                c.getCampaign().setBudgetType(budgetType);
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    c.getCampaign().setDailyBudget(budgetValue);
                } else {
                    c.getCampaign().setMonthlyBudget(budgetValue);
                }
            }
        };
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().size() != 1) {
                    throw new IllegalArgumentException("Only 1 CampaignType can be set in Campaign");
                }
                Collection<CampaignType> campaignTypes = c.getCampaign().getCampaignType();
                return campaignTypes.toArray(new CampaignType[campaignTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                CampaignType campaignType = StringExtensions.parseOptional(v, new Function<String, CampaignType>(){

                    @Override
                    public CampaignType apply(String value) {
                        return CampaignType.fromValue(value);
                    }
                });
                if (campaignType != null) {
                    ArrayList<CampaignType> campaignTypes = new ArrayList<CampaignType>();
                    campaignTypes.add(campaignType);
                    c.getCampaign().setCampaignType(campaignTypes);
                    if (campaignType == CampaignType.SHOPPING) {
                        c.getCampaign().setSettings(new ArrayOfSetting());
                        ShoppingSetting shoppingSetting = new ShoppingSetting();
                        shoppingSetting.setType(ShoppingSetting.class.getSimpleName());
                        c.getCampaign().getSettings().getSettings().add(shoppingSetting);
                    }
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getCampaign().getId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Status", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getStatus() != null ? c.getCampaign().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignStatus>(){

                    @Override
                    public CampaignStatus apply(String value) {
                        return CampaignStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Parent Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setAccountId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Time Zone", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getTimeZone();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTimeZone(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetType() != null ? c.getCampaign().getBudgetType().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetType(StringExtensions.parseOptional(v, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return BudgetLimitType.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetId() != null ? c.getCampaign().getBudgetId().toString() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Name", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getBudgetName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setBudgetName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(budgetToCsv, csvToBudget));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Bid Adjustment", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                return c.getCampaign().getNativeBidAdjustment();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setNativeBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Store Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return null;
                    }
                    return shoppingSetting.getStoreId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return;
                    }
                    shoppingSetting.setStoreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Priority", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return null;
                    }
                    return shoppingSetting.getPriority();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return;
                    }
                    shoppingSetting.setPriority(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                        @Override
                        public Integer apply(String s) {
                            return Integer.parseInt(s);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Country Code", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return null;
                    }
                    return shoppingSetting.getSalesCountryCode();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                if (c.getCampaign().getCampaignType().contains((Object)CampaignType.SHOPPING)) {
                    ShoppingSetting shoppingSetting = c.getShoppingSetting();
                    if (shoppingSetting == null) {
                        return;
                    }
                    shoppingSetting.setSalesCountryCode(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Tracking Template", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toOptionalBulkString(c.getCampaign().getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Custom Parameter", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toCustomParaBulkString(c.getCampaign().getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                try {
                    c.getCampaign().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Bid Strategy Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                try {
                    return StringExtensions.toBiddingSchemeBulkString(c.getCampaign().getBiddingScheme());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                try {
                    c.getCampaign().setBiddingScheme(StringExtensions.parseBiddingScheme(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

