/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.PerformanceData;
import com.microsoft.bingads.campaignmanagement.Ad;
import com.microsoft.bingads.campaignmanagement.AdEditorialStatus;
import com.microsoft.bingads.campaignmanagement.AdStatus;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BulkAd<T extends Ad>
extends SingleRecordBulkEntity {
    private Long adGroupId;
    private String campaignName;
    private String adGroupName;
    protected T ad;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAd>> MAPPINGS;

    BulkAd() {
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    public Long getAdGroupId() {
        return this.adGroupId;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public T getAd() {
        return this.ad;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setAd(T ad) {
        this.ad = ad;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAd, Object>> m = new ArrayList<SimpleBulkMapping<BulkAd, Object>>();
        m.add(new SimpleBulkMapping<BulkAd, String>("Status", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return ((Ad)c.getAd()).getStatus() != null ? ((Ad)c.getAd()).getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setStatus(StringExtensions.parseOptional(v, new Function<String, AdStatus>(){

                    @Override
                    public AdStatus apply(String value) {
                        return AdStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, Long>("Id", new Function<BulkAd, Long>(){

            @Override
            public Long apply(BulkAd c) {
                return ((Ad)c.getAd()).getId();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, Long>("Parent Id", new Function<BulkAd, Long>(){

            @Override
            public Long apply(BulkAd c) {
                return c.getAdGroupId();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Campaign", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Ad Group", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Editorial Status", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd t) {
                return ((Ad)t.getAd()).getEditorialStatus() != null ? ((Ad)t.getAd()).getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, AdEditorialStatus>(){

                    @Override
                    public AdEditorialStatus apply(String value) {
                        return AdEditorialStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Device Preference", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.toDevicePreferenceBulkString(((Ad)c.getAd()).getDevicePreference());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setDevicePreference(StringExtensions.parseDevicePreference(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

