/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.transport.IotHubListener;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.ReactorRunnerStateCallback;
import java.util.concurrent.Callable;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.reactor.Reactor;

public class ReactorRunner
implements Callable<Object> {
    static final String THREAD_NAME = "azure-iot-sdk-ReactorRunner";
    private final Reactor reactor;
    private final IotHubListener listener;
    private final String connectionId;
    private final String threadName;
    private final ReactorRunnerStateCallback reactorRunnerStateCallback;

    ReactorRunner(Reactor reactor, IotHubListener listener, String connectionId, String threadName, ReactorRunnerStateCallback reactorRunnerStateCallback) {
        this.listener = listener;
        this.reactor = reactor;
        this.connectionId = connectionId;
        this.threadName = threadName;
        this.reactorRunnerStateCallback = reactorRunnerStateCallback;
    }

    @Override
    public Object call() {
        try {
            Thread.currentThread().setName(this.threadName);
            this.reactor.setTimeout(10L);
            this.reactor.start();
            while (this.reactor.process()) {
            }
            this.reactor.stop();
            this.reactor.process();
        }
        catch (HandlerException e) {
            TransportException transportException = new TransportException(e);
            transportException.setRetryable(true);
            this.reactorRunnerStateCallback.onReactorClosedUnexpectedly();
            this.listener.onConnectionLost(transportException, this.connectionId);
        }
        finally {
            this.reactor.free();
        }
        return null;
    }
}

