/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMethodsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMethodsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendResult;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTelemetryReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTelemetrySenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTwinReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTwinSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.SendResult;
import com.microsoft.azure.sdk.iot.device.transport.amqps.SubscriptionType;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpsSessionHandler
extends BaseHandler
implements AmqpsLinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpsSessionHandler.class);
    private final ClientConfiguration clientConfiguration;
    private final Map<Integer, SubscriptionType> implicitInProgressSubscriptionMessages = new ConcurrentHashMap<Integer, SubscriptionType>();
    private IotHubTransportMessage explicitInProgressTwinSubscriptionMessage;
    private IotHubTransportMessage explicitInProgressMethodsSubscriptionMessage;
    private boolean subscribeToMethodsOnReconnection = false;
    private boolean subscribeToTwinOnReconnection = false;
    private final AmqpsSessionStateCallback amqpsSessionStateCallback;
    private final Map<MessageType, AmqpsSenderLinkHandler> senderLinkHandlers = new ConcurrentHashMap<MessageType, AmqpsSenderLinkHandler>();
    private final Map<MessageType, AmqpsReceiverLinkHandler> receiverLinkHandlers = new ConcurrentHashMap<MessageType, AmqpsReceiverLinkHandler>();
    private Session session;
    private boolean alreadyCreatedTelemetryLinks;
    private boolean alreadyCreatedTwinLinks;
    private boolean alreadyCreatedMethodLinks;
    private boolean twinSenderLinkOpened;
    private boolean twinReceiverLinkOpened;
    private boolean methodsSenderLinkOpened;
    private boolean methodsReceiverLinkOpened;
    private boolean sessionOpenedRemotely;
    private boolean sessionHandlerClosedBeforeRemoteSessionOpened;
    private boolean isClosing;

    AmqpsSessionHandler(ClientConfiguration clientConfiguration, AmqpsSessionStateCallback amqpsSessionStateCallback) {
        this.clientConfiguration = clientConfiguration;
        this.amqpsSessionStateCallback = amqpsSessionStateCallback;
    }

    public void setSession(Session session) {
        this.session = session;
        BaseHandler.setHandler((Extendable)this.session, (Handler)this);
        log.trace("Opening device session for device {}", (Object)this.getDeviceId());
        this.session.open();
        this.alreadyCreatedTelemetryLinks = false;
        this.alreadyCreatedTwinLinks = false;
        this.alreadyCreatedMethodLinks = false;
        this.senderLinkHandlers.clear();
        this.receiverLinkHandlers.clear();
        this.explicitInProgressTwinSubscriptionMessage = null;
        this.explicitInProgressMethodsSubscriptionMessage = null;
        this.implicitInProgressSubscriptionMessages.clear();
        this.twinSenderLinkOpened = false;
        this.twinReceiverLinkOpened = false;
        this.methodsSenderLinkOpened = false;
        this.methodsReceiverLinkOpened = false;
        this.sessionOpenedRemotely = false;
        this.sessionHandlerClosedBeforeRemoteSessionOpened = false;
        this.isClosing = false;
    }

    public void closeSession() {
        if (this.session != null) {
            if (this.sessionOpenedRemotely) {
                this.isClosing = true;
                this.session.close();
                if (this.session.getLocalState() == EndpointState.CLOSED) {
                    this.amqpsSessionStateCallback.onSessionClosedAsExpected(this.getDeviceId());
                }
            } else {
                log.trace("Session handler was closed but the service has not opened the session remotely yet, so the session will be closed once that happens.");
                this.sessionHandlerClosedBeforeRemoteSessionOpened = true;
            }
        }
    }

    public String getDeviceId() {
        return this.clientConfiguration.getDeviceId();
    }

    public void onSessionFinal(Event e) {
        this.session.free();
    }

    public void onSessionRemoteOpen(Event e) {
        log.trace("Device session opened remotely for device {}", (Object)this.getDeviceId());
        this.sessionOpenedRemotely = true;
        if (this.sessionHandlerClosedBeforeRemoteSessionOpened) {
            log.trace("Closing an out of date session now that the service has opened the session remotely.");
            this.session.close();
        } else if (this.clientConfiguration.getAuthenticationType() == ClientConfiguration.AuthType.X509_CERTIFICATE) {
            log.trace("Opening worker links for device {}", (Object)this.getDeviceId());
            this.openLinks();
        }
    }

    public void onSessionLocalOpen(Event e) {
        log.trace("Device session opened locally for device {}", (Object)this.getDeviceId());
    }

    public void onSessionRemoteClose(Event e) {
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.ACTIVE || !this.isClosing) {
            this.session.close();
            log.debug("Amqp device session closed remotely unexpectedly for device {}", (Object)this.getDeviceId());
            this.clearHandlers();
            this.amqpsSessionStateCallback.onSessionClosedUnexpectedly(session.getRemoteCondition(), this.getDeviceId());
        } else {
            log.trace("Amqp device session closed remotely as expected for device {}", (Object)this.getDeviceId());
            this.clearHandlers();
            this.amqpsSessionStateCallback.onSessionClosedAsExpected(this.getDeviceId());
        }
    }

    public void onSessionLocalClose(Event e) {
        log.debug("Amqp session closed locally for device {}", (Object)this.getDeviceId());
        this.closeLinks();
        this.senderLinkHandlers.clear();
        this.receiverLinkHandlers.clear();
    }

    @Override
    public void onLinkOpened(BaseHandler linkHandler) {
        boolean allLinksOpen = true;
        for (AmqpsSenderLinkHandler senderLinkHandler : this.senderLinkHandlers.values()) {
            allLinksOpen &= senderLinkHandler.senderLink != null && senderLinkHandler.senderLink.getRemoteState() == EndpointState.ACTIVE;
        }
        for (AmqpsReceiverLinkHandler receiverLinkHandler : this.receiverLinkHandlers.values()) {
            allLinksOpen &= receiverLinkHandler.receiverLink != null && receiverLinkHandler.receiverLink.getRemoteState() == EndpointState.ACTIVE;
        }
        if (allLinksOpen) {
            log.trace("Device session for device {} has finished opening its worker links. Notifying the connection layer.", (Object)this.getDeviceId());
            this.amqpsSessionStateCallback.onDeviceSessionOpened(this.getDeviceId());
        }
        if (linkHandler instanceof AmqpsTwinSenderLinkHandler) {
            int deliveryTag = ((AmqpsTwinSenderLinkHandler)linkHandler).sendDesiredPropertiesSubscriptionMessage();
            if (deliveryTag == -1) {
                log.warn("Failed to send desired properties subscription message");
            } else {
                this.implicitInProgressSubscriptionMessages.put(deliveryTag, SubscriptionType.DESIRED_PROPERTIES_SUBSCRIPTION);
            }
        }
        this.acknowledgeExplicitSubscriptionMessages(linkHandler);
    }

    private void acknowledgeExplicitSubscriptionMessages(BaseHandler linkHandler) {
        if (linkHandler instanceof AmqpsTwinSenderLinkHandler) {
            this.twinSenderLinkOpened = true;
        } else if (linkHandler instanceof AmqpsTwinReceiverLinkHandler) {
            this.twinReceiverLinkOpened = true;
        } else if (linkHandler instanceof AmqpsMethodsSenderLinkHandler) {
            this.methodsSenderLinkOpened = true;
            if (this.methodsReceiverLinkOpened && this.explicitInProgressMethodsSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressMethodsSubscriptionMessage, (DeliveryState)Accepted.getInstance(), this.getDeviceId());
                this.explicitInProgressMethodsSubscriptionMessage = null;
            }
        } else if (linkHandler instanceof AmqpsMethodsReceiverLinkHandler) {
            this.methodsReceiverLinkOpened = true;
            if (this.methodsSenderLinkOpened && this.explicitInProgressMethodsSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressMethodsSubscriptionMessage, (DeliveryState)Accepted.getInstance(), this.getDeviceId());
                this.explicitInProgressMethodsSubscriptionMessage = null;
            }
        }
    }

    @Override
    public void onMessageAcknowledged(Message message, int deliveryTag, DeliveryState deliveryState) {
        if (this.implicitInProgressSubscriptionMessages.containsKey(deliveryTag)) {
            this.implicitInProgressSubscriptionMessages.remove(deliveryTag);
            log.trace("The acknowledged message was the desired properties subscription message");
            this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressTwinSubscriptionMessage, (DeliveryState)Accepted.getInstance(), this.getDeviceId());
            this.explicitInProgressTwinSubscriptionMessage = null;
        } else {
            this.amqpsSessionStateCallback.onMessageAcknowledged(message, deliveryState, this.getDeviceId());
        }
    }

    @Override
    public void onMessageReceived(IotHubTransportMessage message) {
        message.setConnectionDeviceId(this.getDeviceId());
        this.amqpsSessionStateCallback.onMessageReceived(message);
    }

    @Override
    public void onLinkClosedUnexpectedly(ErrorCondition errorCondition) {
        log.trace("Link closed unexpectedly for the amqp session of device {}", (Object)this.getDeviceId());
        this.session.close();
        this.amqpsSessionStateCallback.onSessionClosedUnexpectedly(errorCondition, this.getDeviceId());
    }

    public boolean acknowledgeReceivedMessage(IotHubTransportMessage message, DeliveryState ackType) {
        AmqpsReceiverLinkHandler receiverLinkHandler = this.receiverLinkHandlers.get((Object)message.getMessageType());
        if (receiverLinkHandler != null) {
            return receiverLinkHandler.acknowledgeReceivedMessage(message, ackType);
        }
        log.warn("Failed to acknowledge the received message because its receiver link is no longer active");
        return false;
    }

    void openLinks() {
        if (!this.alreadyCreatedTelemetryLinks) {
            this.createTelemetryLinksAsync();
        }
        if (this.subscribeToTwinOnReconnection && !this.alreadyCreatedTwinLinks) {
            this.createTwinLinksAsync();
        }
        if (this.subscribeToMethodsOnReconnection && !this.alreadyCreatedMethodLinks) {
            this.createMethodLinksAsync();
        }
    }

    SendResult sendMessage(Message message) {
        AmqpsSendResult amqpsSendResult;
        AmqpsSenderLinkHandler senderLinkHandler;
        if (!this.clientConfiguration.getDeviceId().equals(message.getConnectionDeviceId())) {
            log.warn("Failed to send the message because this session belongs to a different device");
            return SendResult.WRONG_DEVICE;
        }
        MessageType messageType = message.getMessageType();
        if (messageType == null) {
            messageType = MessageType.DEVICE_TELEMETRY;
        }
        if (message instanceof IotHubTransportMessage) {
            IotHubTransportMessage transportMessage = (IotHubTransportMessage)message;
            Object subscriptionType = transportMessage.getDeviceOperationType();
            if (subscriptionType == DeviceOperations.DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST) {
                return this.handleMethodSubscriptionRequest(transportMessage);
            }
            if (subscriptionType == DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST) {
                return this.handleTwinSubscriptionRequest(transportMessage);
            }
        }
        if ((senderLinkHandler = this.senderLinkHandlers.get((Object)messageType)) == null) {
            return SendResult.LINKS_NOT_OPEN;
        }
        if (messageType == MessageType.DEVICE_TWIN) {
            if (this.explicitInProgressTwinSubscriptionMessage != null) {
                return SendResult.SUBSCRIPTION_IN_PROGRESS;
            }
            for (SubscriptionType subscriptionType : this.implicitInProgressSubscriptionMessages.values()) {
                if (subscriptionType != SubscriptionType.DESIRED_PROPERTIES_SUBSCRIPTION) continue;
                return SendResult.SUBSCRIPTION_IN_PROGRESS;
            }
        }
        if ((amqpsSendResult = senderLinkHandler.sendMessageAndGetDeliveryTag(message)).isDeliverySuccessful()) {
            return SendResult.SUCCESS;
        }
        return SendResult.UNKNOWN_FAILURE;
    }

    private SendResult handleTwinSubscriptionRequest(IotHubTransportMessage transportMessage) {
        if (this.twinSenderLinkOpened && this.twinReceiverLinkOpened) {
            log.trace("Automatically acknowledging the twin subscription request because the twin links are already open");
            this.amqpsSessionStateCallback.onMessageAcknowledged(transportMessage, (DeliveryState)Accepted.getInstance(), this.getDeviceId());
            return SendResult.SUCCESS;
        }
        if (this.explicitInProgressTwinSubscriptionMessage == null) {
            log.trace("Creating the twin links to handle the twin subscription message");
            this.createTwinLinksAsync();
            this.explicitInProgressTwinSubscriptionMessage = transportMessage;
            return SendResult.SUCCESS;
        }
        log.debug("Rejecting twin subscription message because that subscription is already in progress");
        return SendResult.DUPLICATE_SUBSCRIPTION_MESSAGE;
    }

    private SendResult handleMethodSubscriptionRequest(IotHubTransportMessage transportMessage) {
        if (this.methodsSenderLinkOpened && this.methodsReceiverLinkOpened) {
            log.trace("Automatically acknowledging the direct method subscription request because the direct method links are already open");
            this.amqpsSessionStateCallback.onMessageAcknowledged(transportMessage, (DeliveryState)Accepted.getInstance(), this.getDeviceId());
            return SendResult.SUCCESS;
        }
        if (this.explicitInProgressMethodsSubscriptionMessage == null) {
            log.trace("Creating the direct method links to handle the direct method subscription message");
            this.createMethodLinksAsync();
            this.explicitInProgressMethodsSubscriptionMessage = transportMessage;
            return SendResult.SUCCESS;
        }
        log.debug("Rejecting methods subscription message because that subscription is already in progress");
        return SendResult.DUPLICATE_SUBSCRIPTION_MESSAGE;
    }

    private void closeLinks() {
        for (AmqpsSenderLinkHandler senderLinkHandler : this.senderLinkHandlers.values()) {
            senderLinkHandler.close();
        }
        for (AmqpsReceiverLinkHandler receiverLinkHandler : this.receiverLinkHandlers.values()) {
            receiverLinkHandler.close();
        }
    }

    private void createTelemetryLinksAsync() {
        String telemetryLinkCorrelationId = UUID.randomUUID().toString();
        Sender sender = this.session.sender(AmqpsTelemetrySenderLinkHandler.getTag(this.clientConfiguration, telemetryLinkCorrelationId));
        this.senderLinkHandlers.put(MessageType.DEVICE_TELEMETRY, new AmqpsTelemetrySenderLinkHandler(sender, (AmqpsLinkStateCallback)this, this.clientConfiguration, telemetryLinkCorrelationId));
        Receiver receiver = this.session.receiver(AmqpsTelemetryReceiverLinkHandler.getTag(this.clientConfiguration, telemetryLinkCorrelationId));
        this.receiverLinkHandlers.put(MessageType.DEVICE_TELEMETRY, new AmqpsTelemetryReceiverLinkHandler(receiver, this, this.clientConfiguration, telemetryLinkCorrelationId));
        this.alreadyCreatedTelemetryLinks = true;
    }

    private void createMethodLinksAsync() {
        log.debug("Creating direct method links");
        String methodsLinkCorrelationId = UUID.randomUUID().toString();
        Sender sender = this.session.sender(AmqpsMethodsSenderLinkHandler.getTag(this.clientConfiguration, methodsLinkCorrelationId));
        this.senderLinkHandlers.put(MessageType.DEVICE_METHODS, new AmqpsMethodsSenderLinkHandler(sender, (AmqpsLinkStateCallback)this, this.clientConfiguration, methodsLinkCorrelationId));
        Receiver receiver = this.session.receiver(AmqpsMethodsReceiverLinkHandler.getTag(this.clientConfiguration, methodsLinkCorrelationId));
        this.receiverLinkHandlers.put(MessageType.DEVICE_METHODS, new AmqpsMethodsReceiverLinkHandler(receiver, this, this.clientConfiguration, methodsLinkCorrelationId));
        this.subscribeToMethodsOnReconnection = true;
        this.alreadyCreatedMethodLinks = true;
    }

    private void createTwinLinksAsync() {
        log.debug("Creating twin links");
        String twinLinkCorrelationId = UUID.randomUUID().toString();
        HashMap<String, DeviceOperations> twinOperationCorrelationMap = new HashMap<String, DeviceOperations>();
        Sender sender = this.session.sender(AmqpsTwinSenderLinkHandler.getTag(this.clientConfiguration, twinLinkCorrelationId));
        this.senderLinkHandlers.put(MessageType.DEVICE_TWIN, new AmqpsTwinSenderLinkHandler(sender, this, this.clientConfiguration, twinLinkCorrelationId, twinOperationCorrelationMap));
        Receiver receiver = this.session.receiver(AmqpsTwinReceiverLinkHandler.getTag(this.clientConfiguration, twinLinkCorrelationId));
        this.receiverLinkHandlers.put(MessageType.DEVICE_TWIN, new AmqpsTwinReceiverLinkHandler(receiver, this, this.clientConfiguration, twinLinkCorrelationId, twinOperationCorrelationMap));
        this.subscribeToTwinOnReconnection = true;
        this.alreadyCreatedTwinLinks = true;
    }

    private void clearHandlers() {
        this.session.attachments().clear();
        Iterator childrenIterator = this.children();
        while (childrenIterator.hasNext()) {
            childrenIterator.next();
            childrenIterator.remove();
        }
        this.session.free();
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

