/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SignatureHelper {
    private static final Logger log = LoggerFactory.getLogger(SignatureHelper.class);
    private static final String RAW_SIGNATURE_FORMAT = "%s\n%s";
    private static final Charset SIGNATURE_CHARSET = StandardCharsets.UTF_8;

    public static byte[] buildRawSignature(String resourceUri, long expiryTime) {
        return String.format(RAW_SIGNATURE_FORMAT, resourceUri, expiryTime).getBytes(SIGNATURE_CHARSET);
    }

    public static byte[] decodeDeviceKeyBase64(String deviceKey) {
        return Base64.decodeBase64((byte[])deviceKey.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encryptSignatureHmacSha256(byte[] sig, byte[] deviceKey) {
        String hmacSha256 = "HmacSHA256";
        SecretKeySpec secretKey = new SecretKeySpec(deviceKey, hmacSha256);
        byte[] encryptedSig = null;
        try {
            Mac hMacSha256 = Mac.getInstance(hmacSha256);
            hMacSha256.init(secretKey);
            encryptedSig = hMacSha256.doFinal(sig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Unexpected error encountered while encrypting signature", (Throwable)e);
        }
        return encryptedSig;
    }

    public static byte[] encodeSignatureBase64(byte[] sig) {
        return Base64.encodeBase64((byte[])sig);
    }

    public static String encodeSignatureUtf8(byte[] sig) {
        return new String(sig, SIGNATURE_CHARSET);
    }

    public static String encodeSignatureWebSafe(String sig) {
        String strSig;
        try {
            strSig = URLEncoder.encode(sig, SIGNATURE_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return strSig;
    }

    protected SignatureHelper() {
    }
}

