/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import javax.net.ssl.SSLContext;

public final class ClientOptions {
    private static final int DEFAULT_HTTPS_CONNECT_TIMEOUT_MILLISECONDS = 0;
    private static final int DEFAULT_HTTPS_READ_TIMEOUT_MILLISECONDS = 240000;
    private static final long DEFAULT_SAS_TOKEN_EXPIRY_TIME_SECONDS = 3600L;
    private static final int DEFAULT_MAX_MESSAGES_TO_SEND_PER_THREAD = 10;
    private static final int SEND_PERIOD_MILLIS = 10;
    private static final int RECEIVE_PERIOD_MILLIS = 10;
    private final String modelId;
    private final SSLContext sslContext;
    private final ProxySettings proxySettings;
    private final int keepAliveInterval;
    private final int httpsReadTimeout;
    private final int httpsConnectTimeout;
    private final long sasTokenExpiryTime;
    private final int amqpAuthenticationSessionTimeout;
    private final int amqpDeviceSessionTimeout;
    private final int messagesSentPerSendInterval;
    private final int sendInterval;
    private final int receiveInterval;
    private final String threadNamePrefix;
    private final String threadNameSuffix;
    private final boolean useIdentifiableThreadNames;
    private final boolean logRoutineDisconnectsAsErrors;
    private final long messageExpirationCheckPeriod;

    public boolean isUsingIdentifiableThreadNames() {
        return this.useIdentifiableThreadNames;
    }

    public boolean isLoggingRoutineDisconnectsAsErrors() {
        return this.logRoutineDisconnectsAsErrors;
    }

    private static int $default$keepAliveInterval() {
        return 230;
    }

    private static int $default$httpsReadTimeout() {
        return 240000;
    }

    private static int $default$httpsConnectTimeout() {
        return 0;
    }

    private static long $default$sasTokenExpiryTime() {
        return 3600L;
    }

    private static int $default$amqpAuthenticationSessionTimeout() {
        return 20;
    }

    private static int $default$amqpDeviceSessionTimeout() {
        return 60;
    }

    private static int $default$messagesSentPerSendInterval() {
        return 10;
    }

    private static int $default$sendInterval() {
        return 10;
    }

    private static int $default$receiveInterval() {
        return 10;
    }

    private static String $default$threadNamePrefix() {
        return null;
    }

    private static String $default$threadNameSuffix() {
        return null;
    }

    private static boolean $default$useIdentifiableThreadNames() {
        return true;
    }

    private static boolean $default$logRoutineDisconnectsAsErrors() {
        return true;
    }

    private static long $default$messageExpirationCheckPeriod() {
        return 10000L;
    }

    ClientOptions(String modelId, SSLContext sslContext, ProxySettings proxySettings, int keepAliveInterval, int httpsReadTimeout, int httpsConnectTimeout, long sasTokenExpiryTime, int amqpAuthenticationSessionTimeout, int amqpDeviceSessionTimeout, int messagesSentPerSendInterval, int sendInterval, int receiveInterval, String threadNamePrefix, String threadNameSuffix, boolean useIdentifiableThreadNames, boolean logRoutineDisconnectsAsErrors, long messageExpirationCheckPeriod) {
        this.modelId = modelId;
        this.sslContext = sslContext;
        this.proxySettings = proxySettings;
        this.keepAliveInterval = keepAliveInterval;
        this.httpsReadTimeout = httpsReadTimeout;
        this.httpsConnectTimeout = httpsConnectTimeout;
        this.sasTokenExpiryTime = sasTokenExpiryTime;
        this.amqpAuthenticationSessionTimeout = amqpAuthenticationSessionTimeout;
        this.amqpDeviceSessionTimeout = amqpDeviceSessionTimeout;
        this.messagesSentPerSendInterval = messagesSentPerSendInterval;
        this.sendInterval = sendInterval;
        this.receiveInterval = receiveInterval;
        this.threadNamePrefix = threadNamePrefix;
        this.threadNameSuffix = threadNameSuffix;
        this.useIdentifiableThreadNames = useIdentifiableThreadNames;
        this.logRoutineDisconnectsAsErrors = logRoutineDisconnectsAsErrors;
        this.messageExpirationCheckPeriod = messageExpirationCheckPeriod;
    }

    public static ClientOptionsBuilder builder() {
        return new ClientOptionsBuilder();
    }

    public ClientOptionsBuilder toBuilder() {
        return new ClientOptionsBuilder().modelId(this.modelId).sslContext(this.sslContext).proxySettings(this.proxySettings).keepAliveInterval(this.keepAliveInterval).httpsReadTimeout(this.httpsReadTimeout).httpsConnectTimeout(this.httpsConnectTimeout).sasTokenExpiryTime(this.sasTokenExpiryTime).amqpAuthenticationSessionTimeout(this.amqpAuthenticationSessionTimeout).amqpDeviceSessionTimeout(this.amqpDeviceSessionTimeout).messagesSentPerSendInterval(this.messagesSentPerSendInterval).sendInterval(this.sendInterval).receiveInterval(this.receiveInterval).threadNamePrefix(this.threadNamePrefix).threadNameSuffix(this.threadNameSuffix).useIdentifiableThreadNames(this.useIdentifiableThreadNames).logRoutineDisconnectsAsErrors(this.logRoutineDisconnectsAsErrors).messageExpirationCheckPeriod(this.messageExpirationCheckPeriod);
    }

    public String getModelId() {
        return this.modelId;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public int getHttpsReadTimeout() {
        return this.httpsReadTimeout;
    }

    public int getHttpsConnectTimeout() {
        return this.httpsConnectTimeout;
    }

    public long getSasTokenExpiryTime() {
        return this.sasTokenExpiryTime;
    }

    public int getAmqpAuthenticationSessionTimeout() {
        return this.amqpAuthenticationSessionTimeout;
    }

    public int getAmqpDeviceSessionTimeout() {
        return this.amqpDeviceSessionTimeout;
    }

    public int getMessagesSentPerSendInterval() {
        return this.messagesSentPerSendInterval;
    }

    public int getSendInterval() {
        return this.sendInterval;
    }

    public int getReceiveInterval() {
        return this.receiveInterval;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public String getThreadNameSuffix() {
        return this.threadNameSuffix;
    }

    public long getMessageExpirationCheckPeriod() {
        return this.messageExpirationCheckPeriod;
    }

    public static class ClientOptionsBuilder {
        private String modelId;
        private SSLContext sslContext;
        private ProxySettings proxySettings;
        private boolean keepAliveInterval$set;
        private int keepAliveInterval$value;
        private boolean httpsReadTimeout$set;
        private int httpsReadTimeout$value;
        private boolean httpsConnectTimeout$set;
        private int httpsConnectTimeout$value;
        private boolean sasTokenExpiryTime$set;
        private long sasTokenExpiryTime$value;
        private boolean amqpAuthenticationSessionTimeout$set;
        private int amqpAuthenticationSessionTimeout$value;
        private boolean amqpDeviceSessionTimeout$set;
        private int amqpDeviceSessionTimeout$value;
        private boolean messagesSentPerSendInterval$set;
        private int messagesSentPerSendInterval$value;
        private boolean sendInterval$set;
        private int sendInterval$value;
        private boolean receiveInterval$set;
        private int receiveInterval$value;
        private boolean threadNamePrefix$set;
        private String threadNamePrefix$value;
        private boolean threadNameSuffix$set;
        private String threadNameSuffix$value;
        private boolean useIdentifiableThreadNames$set;
        private boolean useIdentifiableThreadNames$value;
        private boolean logRoutineDisconnectsAsErrors$set;
        private boolean logRoutineDisconnectsAsErrors$value;
        private boolean messageExpirationCheckPeriod$set;
        private long messageExpirationCheckPeriod$value;

        ClientOptionsBuilder() {
        }

        public ClientOptionsBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public ClientOptionsBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public ClientOptionsBuilder proxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public ClientOptionsBuilder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval$value = keepAliveInterval;
            this.keepAliveInterval$set = true;
            return this;
        }

        public ClientOptionsBuilder httpsReadTimeout(int httpsReadTimeout) {
            this.httpsReadTimeout$value = httpsReadTimeout;
            this.httpsReadTimeout$set = true;
            return this;
        }

        public ClientOptionsBuilder httpsConnectTimeout(int httpsConnectTimeout) {
            this.httpsConnectTimeout$value = httpsConnectTimeout;
            this.httpsConnectTimeout$set = true;
            return this;
        }

        public ClientOptionsBuilder sasTokenExpiryTime(long sasTokenExpiryTime) {
            this.sasTokenExpiryTime$value = sasTokenExpiryTime;
            this.sasTokenExpiryTime$set = true;
            return this;
        }

        public ClientOptionsBuilder amqpAuthenticationSessionTimeout(int amqpAuthenticationSessionTimeout) {
            this.amqpAuthenticationSessionTimeout$value = amqpAuthenticationSessionTimeout;
            this.amqpAuthenticationSessionTimeout$set = true;
            return this;
        }

        public ClientOptionsBuilder amqpDeviceSessionTimeout(int amqpDeviceSessionTimeout) {
            this.amqpDeviceSessionTimeout$value = amqpDeviceSessionTimeout;
            this.amqpDeviceSessionTimeout$set = true;
            return this;
        }

        public ClientOptionsBuilder messagesSentPerSendInterval(int messagesSentPerSendInterval) {
            this.messagesSentPerSendInterval$value = messagesSentPerSendInterval;
            this.messagesSentPerSendInterval$set = true;
            return this;
        }

        public ClientOptionsBuilder sendInterval(int sendInterval) {
            this.sendInterval$value = sendInterval;
            this.sendInterval$set = true;
            return this;
        }

        public ClientOptionsBuilder receiveInterval(int receiveInterval) {
            this.receiveInterval$value = receiveInterval;
            this.receiveInterval$set = true;
            return this;
        }

        public ClientOptionsBuilder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix$value = threadNamePrefix;
            this.threadNamePrefix$set = true;
            return this;
        }

        public ClientOptionsBuilder threadNameSuffix(String threadNameSuffix) {
            this.threadNameSuffix$value = threadNameSuffix;
            this.threadNameSuffix$set = true;
            return this;
        }

        public ClientOptionsBuilder useIdentifiableThreadNames(boolean useIdentifiableThreadNames) {
            this.useIdentifiableThreadNames$value = useIdentifiableThreadNames;
            this.useIdentifiableThreadNames$set = true;
            return this;
        }

        public ClientOptionsBuilder logRoutineDisconnectsAsErrors(boolean logRoutineDisconnectsAsErrors) {
            this.logRoutineDisconnectsAsErrors$value = logRoutineDisconnectsAsErrors;
            this.logRoutineDisconnectsAsErrors$set = true;
            return this;
        }

        public ClientOptionsBuilder messageExpirationCheckPeriod(long messageExpirationCheckPeriod) {
            this.messageExpirationCheckPeriod$value = messageExpirationCheckPeriod;
            this.messageExpirationCheckPeriod$set = true;
            return this;
        }

        public ClientOptions build() {
            int keepAliveInterval$value = this.keepAliveInterval$value;
            if (!this.keepAliveInterval$set) {
                keepAliveInterval$value = ClientOptions.$default$keepAliveInterval();
            }
            int httpsReadTimeout$value = this.httpsReadTimeout$value;
            if (!this.httpsReadTimeout$set) {
                httpsReadTimeout$value = ClientOptions.$default$httpsReadTimeout();
            }
            int httpsConnectTimeout$value = this.httpsConnectTimeout$value;
            if (!this.httpsConnectTimeout$set) {
                httpsConnectTimeout$value = ClientOptions.$default$httpsConnectTimeout();
            }
            long sasTokenExpiryTime$value = this.sasTokenExpiryTime$value;
            if (!this.sasTokenExpiryTime$set) {
                sasTokenExpiryTime$value = ClientOptions.$default$sasTokenExpiryTime();
            }
            int amqpAuthenticationSessionTimeout$value = this.amqpAuthenticationSessionTimeout$value;
            if (!this.amqpAuthenticationSessionTimeout$set) {
                amqpAuthenticationSessionTimeout$value = ClientOptions.$default$amqpAuthenticationSessionTimeout();
            }
            int amqpDeviceSessionTimeout$value = this.amqpDeviceSessionTimeout$value;
            if (!this.amqpDeviceSessionTimeout$set) {
                amqpDeviceSessionTimeout$value = ClientOptions.$default$amqpDeviceSessionTimeout();
            }
            int messagesSentPerSendInterval$value = this.messagesSentPerSendInterval$value;
            if (!this.messagesSentPerSendInterval$set) {
                messagesSentPerSendInterval$value = ClientOptions.$default$messagesSentPerSendInterval();
            }
            int sendInterval$value = this.sendInterval$value;
            if (!this.sendInterval$set) {
                sendInterval$value = ClientOptions.$default$sendInterval();
            }
            int receiveInterval$value = this.receiveInterval$value;
            if (!this.receiveInterval$set) {
                receiveInterval$value = ClientOptions.$default$receiveInterval();
            }
            String threadNamePrefix$value = this.threadNamePrefix$value;
            if (!this.threadNamePrefix$set) {
                threadNamePrefix$value = ClientOptions.$default$threadNamePrefix();
            }
            String threadNameSuffix$value = this.threadNameSuffix$value;
            if (!this.threadNameSuffix$set) {
                threadNameSuffix$value = ClientOptions.$default$threadNameSuffix();
            }
            boolean useIdentifiableThreadNames$value = this.useIdentifiableThreadNames$value;
            if (!this.useIdentifiableThreadNames$set) {
                useIdentifiableThreadNames$value = ClientOptions.$default$useIdentifiableThreadNames();
            }
            boolean logRoutineDisconnectsAsErrors$value = this.logRoutineDisconnectsAsErrors$value;
            if (!this.logRoutineDisconnectsAsErrors$set) {
                logRoutineDisconnectsAsErrors$value = ClientOptions.$default$logRoutineDisconnectsAsErrors();
            }
            long messageExpirationCheckPeriod$value = this.messageExpirationCheckPeriod$value;
            if (!this.messageExpirationCheckPeriod$set) {
                messageExpirationCheckPeriod$value = ClientOptions.$default$messageExpirationCheckPeriod();
            }
            return new ClientOptions(this.modelId, this.sslContext, this.proxySettings, keepAliveInterval$value, httpsReadTimeout$value, httpsConnectTimeout$value, sasTokenExpiryTime$value, amqpAuthenticationSessionTimeout$value, amqpDeviceSessionTimeout$value, messagesSentPerSendInterval$value, sendInterval$value, receiveInterval$value, threadNamePrefix$value, threadNameSuffix$value, useIdentifiableThreadNames$value, logRoutineDisconnectsAsErrors$value, messageExpirationCheckPeriod$value);
        }

        public String toString() {
            return "ClientOptions.ClientOptionsBuilder(modelId=" + this.modelId + ", sslContext=" + this.sslContext + ", proxySettings=" + this.proxySettings + ", keepAliveInterval$value=" + this.keepAliveInterval$value + ", httpsReadTimeout$value=" + this.httpsReadTimeout$value + ", httpsConnectTimeout$value=" + this.httpsConnectTimeout$value + ", sasTokenExpiryTime$value=" + this.sasTokenExpiryTime$value + ", amqpAuthenticationSessionTimeout$value=" + this.amqpAuthenticationSessionTimeout$value + ", amqpDeviceSessionTimeout$value=" + this.amqpDeviceSessionTimeout$value + ", messagesSentPerSendInterval$value=" + this.messagesSentPerSendInterval$value + ", sendInterval$value=" + this.sendInterval$value + ", receiveInterval$value=" + this.receiveInterval$value + ", threadNamePrefix$value=" + this.threadNamePrefix$value + ", threadNameSuffix$value=" + this.threadNameSuffix$value + ", useIdentifiableThreadNames$value=" + this.useIdentifiableThreadNames$value + ", logRoutineDisconnectsAsErrors$value=" + this.logRoutineDisconnectsAsErrors$value + ", messageExpirationCheckPeriod$value=" + this.messageExpirationCheckPeriod$value + ")";
        }
    }
}

