/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.microsoft.aad.msal4j.AccountCacheEntity;
import com.microsoft.aad.msal4j.AuthenticationErrorCode;
import com.microsoft.aad.msal4j.AuthenticationException;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.B2CAuthority;
import com.microsoft.aad.msal4j.ClaimsChallengeException;
import com.microsoft.aad.msal4j.HttpEvent;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.OAuthHttpRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import com.microsoft.aad.msal4j.TokenResponse;
import com.microsoft.aad.msal4j.XmsClientTelemetryInfo;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenRequest {
    Logger log = LoggerFactory.getLogger(TokenRequest.class);
    private final URL url;
    private final MsalRequest msalRequest;
    private final ServiceBundle serviceBundle;

    TokenRequest(URL url, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        this.url = url;
        this.serviceBundle = serviceBundle;
        this.msalRequest = msalRequest;
    }

    AuthenticationResult executeOauthRequestAndProcessResponse() throws ParseException, AuthenticationException, SerializeException, IOException {
        HttpEvent httpEvent = this.createHttpEvent();
        try (TelemetryHelper telemetryHelper = this.serviceBundle.getTelemetryManager().createTelemetryHelper(this.msalRequest.requestContext().getTelemetryRequestId(), this.msalRequest.application().clientId(), httpEvent, false);){
            AccountCacheEntity accountCacheEntity;
            String refreshToken;
            OIDCTokens tokens;
            TokenResponse response;
            HTTPResponse httpResponse = this.toOauthHttpRequest().send();
            this.addResponseHeadersToHttpEvent(httpEvent, httpResponse);
            if (httpResponse.getStatusCode() == 200) {
                response = TokenResponse.parseHttpResponse(httpResponse);
                tokens = response.getOIDCTokens();
                refreshToken = null;
                if (tokens.getRefreshToken() != null) {
                    refreshToken = tokens.getRefreshToken().getValue();
                }
                accountCacheEntity = null;
                if (tokens.getIDToken() != null) {
                    String idTokenJson = tokens.getIDToken().getParsedParts()[1].decodeToString();
                    IdToken idToken = JsonHelper.convertJsonToObject(idTokenJson, IdToken.class);
                    if (!StringHelper.isBlank(response.getClientInfo())) {
                        AuthorityType type = this.msalRequest.application().authenticationAuthority.authorityType;
                        if (type == AuthorityType.B2C) {
                            B2CAuthority authority = (B2CAuthority)this.msalRequest.application().authenticationAuthority;
                            accountCacheEntity = AccountCacheEntity.create(response.getClientInfo(), this.url.getHost(), idToken, authority.policy);
                        } else {
                            accountCacheEntity = AccountCacheEntity.create(response.getClientInfo(), this.url.getHost(), idToken);
                        }
                    }
                }
            } else {
                TokenErrorResponse errorResponse = TokenErrorResponse.parse((HTTPResponse)httpResponse);
                ErrorObject errorObject = errorResponse.getErrorObject();
                if (AuthenticationErrorCode.AUTHORIZATION_PENDING.toString().equals(errorObject.getCode())) {
                    httpEvent.setOauthErrorCode(AuthenticationErrorCode.AUTHORIZATION_PENDING.toString());
                    throw new AuthenticationException(AuthenticationErrorCode.AUTHORIZATION_PENDING, errorObject.getDescription());
                }
                if (400 == errorObject.getHTTPStatusCode() && AuthenticationErrorCode.INTERACTION_REQUIRED.toString().equals(errorObject.getCode())) {
                    httpEvent.setOauthErrorCode(AuthenticationErrorCode.INTERACTION_REQUIRED.toString());
                    throw new ClaimsChallengeException(errorResponse.toJSONObject().toJSONString(), this.getClaims(httpResponse.getContent()));
                }
                String telemetryErrorCode = Strings.isNullOrEmpty((String)errorObject.getCode()) ? AuthenticationErrorCode.UNKNOWN.toString() : errorObject.getCode();
                httpEvent.setOauthErrorCode(telemetryErrorCode);
                throw new AuthenticationException(errorResponse.toJSONObject().toJSONString());
            }
            long currTimestampSec = new Date().getTime() / 1000L;
            AuthenticationResult result = AuthenticationResult.builder().accessToken(tokens.getAccessToken().getValue()).refreshToken(refreshToken).familyId(response.getFoci()).idToken(tokens.getIDTokenString()).environment(this.url.getHost()).expiresOn(currTimestampSec + response.getExpiresIn()).extExpiresOn(response.getExtExpiresIn() > 0L ? currTimestampSec + response.getExtExpiresIn() : 0L).accountCacheEntity(accountCacheEntity).scopes(response.getScope()).build();
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
    }

    private void addResponseHeadersToHttpEvent(HttpEvent httpEvent, HTTPResponse httpResponse) {
        XmsClientTelemetryInfo xmsClientTelemetryInfo;
        httpEvent.setHttpResponseStatus(httpResponse.getStatusCode());
        if (!Strings.isNullOrEmpty((String)httpResponse.getHeaderValue("User-Agent"))) {
            httpEvent.setUserAgent(httpResponse.getHeaderValue("User-Agent"));
        }
        if (!Strings.isNullOrEmpty((String)httpResponse.getHeaderValue("x-ms-request-id"))) {
            httpEvent.setRequestIdHeader(httpResponse.getHeaderValue("x-ms-request-id"));
        }
        if (!Strings.isNullOrEmpty((String)httpResponse.getHeaderValue("x-ms-clitelem")) && (xmsClientTelemetryInfo = XmsClientTelemetryInfo.parseXmsTelemetryInfo(httpResponse.getHeaderValue("x-ms-clitelem"))) != null) {
            httpEvent.setXmsClientTelemetryInfo(xmsClientTelemetryInfo);
        }
    }

    private HttpEvent createHttpEvent() {
        HttpEvent httpEvent = new HttpEvent();
        httpEvent.setHttpMethod("POST");
        try {
            httpEvent.setHttpPath(this.url.toURI());
            if (!Strings.isNullOrEmpty((String)this.url.getQuery())) {
                httpEvent.setQueryParameters(this.url.getQuery());
            }
        }
        catch (URISyntaxException ex) {
            this.log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(ex), this.msalRequest.headers().getHeaderCorrelationIdValue()));
        }
        return httpEvent;
    }

    private String getClaims(String httpResponseContentStr) {
        JsonElement root = new JsonParser().parse(httpResponseContentStr);
        JsonElement claims = root.getAsJsonObject().get("claims");
        return claims != null ? claims.getAsString() : null;
    }

    OAuthHttpRequest toOauthHttpRequest() throws SerializeException {
        if (this.url == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        OAuthHttpRequest oauthHttpRequest = new OAuthHttpRequest(HTTPRequest.Method.POST, this.url, this.msalRequest.headers().getReadonlyHeaderMap(), this.serviceBundle);
        oauthHttpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, List<String>> params = this.msalRequest.msalAuthorizationGrant().toParameters();
        oauthHttpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.msalRequest.application().clientAuthentication != null) {
            this.msalRequest.application().clientAuthentication.applyTo((HTTPRequest)oauthHttpRequest);
        }
        return oauthHttpRequest;
    }

    Logger getLog() {
        return this.log;
    }

    URL getUrl() {
        return this.url;
    }

    MsalRequest getMsalRequest() {
        return this.msalRequest;
    }

    ServiceBundle getServiceBundle() {
        return this.serviceBundle;
    }
}

