/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ClientDataHttpHeaders;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import java.util.concurrent.CompletionException;

class RemoveAccountRunnable
implements Runnable {
    ClientDataHttpHeaders headers;
    ClientApplicationBase clientApplication;
    IAccount account;

    RemoveAccountRunnable(ClientApplicationBase clientApplication, IAccount account) {
        this.clientApplication = clientApplication;
        this.headers = new ClientDataHttpHeaders(clientApplication.correlationId());
        this.account = account;
    }

    @Override
    public void run() {
        try {
            InstanceDiscoveryMetadataEntry instanceDiscoveryData = AadInstanceDiscovery.cache.get(this.clientApplication.authenticationAuthority.host());
            this.clientApplication.tokenCache.removeAccount(this.clientApplication.clientId(), this.account, instanceDiscoveryData.getAliasesSet());
        }
        catch (Exception ex) {
            this.clientApplication.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.headers.getHeaderCorrelationIdValue()), (Throwable)ex);
            throw new CompletionException(ex);
        }
    }
}

