/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;

class AccountsSupplier
implements Supplier<Set<IAccount>> {
    ClientApplicationBase clientApplication;
    MsalRequest msalRequest;

    AccountsSupplier(ClientApplicationBase clientApplication, MsalRequest msalRequest) {
        this.clientApplication = clientApplication;
        this.msalRequest = msalRequest;
    }

    @Override
    public Set<IAccount> get() {
        try {
            InstanceDiscoveryMetadataEntry instanceDiscoveryData = AadInstanceDiscovery.GetMetadataEntry(new URL(this.clientApplication.authority()), this.clientApplication.validateAuthority(), this.msalRequest, this.clientApplication.getServiceBundle());
            return this.clientApplication.tokenCache.getAccounts(this.clientApplication.clientId(), instanceDiscoveryData.getAliasesSet());
        }
        catch (Exception ex) {
            this.clientApplication.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.msalRequest.headers().getHeaderCorrelationIdValue()), (Throwable)ex);
            throw new CompletionException(ex);
        }
    }
}

