/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AcquireTokenPublicApi;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ClientAuthenticationPost;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationRequest;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.aad.msal4j.UserNamePasswordRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class PublicClientApplication
extends ClientApplicationBase {
    public CompletableFuture<AuthenticationResult> acquireToken(UserNamePasswordParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        UserNamePasswordRequest userNamePasswordRequest = new UserNamePasswordRequest(parameters, this, this.createRequestContext(AcquireTokenPublicApi.ACQUIRE_TOKEN_BY_USERNAME_PASSWORD));
        return this.executeRequest(userNamePasswordRequest);
    }

    public CompletableFuture<AuthenticationResult> acquireToken(IntegratedWindowsAuthenticationParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        IntegratedWindowsAuthenticationRequest integratedWindowsAuthenticationRequest = new IntegratedWindowsAuthenticationRequest(parameters, this, this.createRequestContext(AcquireTokenPublicApi.ACQUIRE_TOKEN_BY_INTEGRATED_WINDOWS_AUTH));
        return this.executeRequest(integratedWindowsAuthenticationRequest);
    }

    public CompletableFuture<AuthenticationResult> acquireToken(DeviceCodeFlowParameters parameters) {
        if (!AuthorityType.AAD.equals((Object)this.authenticationAuthority.authorityType())) {
            throw new IllegalArgumentException("Invalid authority type. Device Flow is only supported by AAD authority");
        }
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        AtomicReference<CompletableFuture<AuthenticationResult>> futureReference = new AtomicReference<CompletableFuture<AuthenticationResult>>();
        DeviceCodeFlowRequest deviceCodeRequest = new DeviceCodeFlowRequest(parameters, futureReference, this, this.createRequestContext(AcquireTokenPublicApi.ACQUIRE_TOKEN_BY_DEVICE_CODE_FLOW));
        CompletableFuture<AuthenticationResult> future = this.executeRequest(deviceCodeRequest);
        futureReference.set(future);
        return future;
    }

    private PublicClientApplication(Builder builder) {
        super(builder);
        this.log = LoggerFactory.getLogger(PublicClientApplication.class);
        this.initClientAuthentication(this.clientId());
    }

    private void initClientAuthentication(String clientId) {
        ParameterValidationUtils.validateNotBlank("clientId", clientId);
        this.clientAuthentication = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId));
    }

    public static Builder builder(String clientId) {
        return new Builder(clientId);
    }

    public static class Builder
    extends ClientApplicationBase.Builder<Builder> {
        Builder(String clientId) {
            super(clientId);
        }

        @Override
        public PublicClientApplication build() {
            return new PublicClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

