/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.Account;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.StringHelper;
import com.nimbusds.jwt.JWTParser;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public final class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final long expiresOn;
    private final long extExpiresOn;
    private final String refreshToken;
    private final String idToken;
    private final AtomicReference<Object> idTokenObject = new AtomicReference();
    private final Account account;
    private String environment;
    private final AtomicReference<Object> expiresOnDate = new AtomicReference();
    private final String scopes;

    private IdToken getIdTokenObj() {
        if (StringHelper.isBlank(this.idToken)) {
            return null;
        }
        try {
            String idTokenJson = JWTParser.parse((String)this.idToken).getParsedParts()[1].decodeToString();
            return JsonHelper.convertJsonToObject(idTokenJson, IdToken.class);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    AuthenticationResult(String accessToken, long expiresOn, long extExpiresOn, String refreshToken, String idToken, Account account, String environment, String scopes) {
        this.accessToken = accessToken;
        this.expiresOn = expiresOn;
        this.extExpiresOn = extExpiresOn;
        this.refreshToken = refreshToken;
        this.idToken = idToken;
        this.account = account;
        this.environment = environment;
        this.scopes = scopes;
    }

    public static AuthenticationResultBuilder builder() {
        return new AuthenticationResultBuilder();
    }

    public String accessToken() {
        return this.accessToken;
    }

    public long expiresOn() {
        return this.expiresOn;
    }

    public long extExpiresOn() {
        return this.extExpiresOn;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public String idToken() {
        return this.idToken;
    }

    public Account account() {
        return this.account;
    }

    public String environment() {
        return this.environment;
    }

    public String scopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult)o;
        String this$accessToken = this.accessToken();
        String other$accessToken = other.accessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        if (this.expiresOn() != other.expiresOn()) {
            return false;
        }
        if (this.extExpiresOn() != other.extExpiresOn()) {
            return false;
        }
        String this$refreshToken = this.refreshToken();
        String other$refreshToken = other.refreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$idToken = this.idToken();
        String other$idToken = other.idToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
            return false;
        }
        IdToken this$idTokenObject = this.idTokenObject();
        IdToken other$idTokenObject = other.idTokenObject();
        if (this$idTokenObject == null ? other$idTokenObject != null : !this$idTokenObject.equals(other$idTokenObject)) {
            return false;
        }
        Account this$account = this.account();
        Account other$account = other.account();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        String this$environment = this.environment();
        String other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        Date this$expiresOnDate = this.expiresOnDate();
        Date other$expiresOnDate = other.expiresOnDate();
        if (this$expiresOnDate == null ? other$expiresOnDate != null : !((Object)this$expiresOnDate).equals(other$expiresOnDate)) {
            return false;
        }
        String this$scopes = this.scopes();
        String other$scopes = other.scopes();
        return !(this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessToken = this.accessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        long $expiresOn = this.expiresOn();
        result = result * 59 + (int)($expiresOn >>> 32 ^ $expiresOn);
        long $extExpiresOn = this.extExpiresOn();
        result = result * 59 + (int)($extExpiresOn >>> 32 ^ $extExpiresOn);
        String $refreshToken = this.refreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $idToken = this.idToken();
        result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
        IdToken $idTokenObject = this.idTokenObject();
        result = result * 59 + ($idTokenObject == null ? 43 : $idTokenObject.hashCode());
        Account $account = this.account();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        String $environment = this.environment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        Date $expiresOnDate = this.expiresOnDate();
        result = result * 59 + ($expiresOnDate == null ? 43 : ((Object)$expiresOnDate).hashCode());
        String $scopes = this.scopes();
        result = result * 59 + ($scopes == null ? 43 : $scopes.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IdToken idTokenObject() {
        Object value = this.idTokenObject.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idTokenObject;
            synchronized (atomicReference) {
                value = this.idTokenObject.get();
                if (value == null) {
                    IdToken actualValue = this.getIdTokenObj();
                    value = actualValue == null ? this.idTokenObject : actualValue;
                    this.idTokenObject.set(value);
                }
            }
        }
        return (IdToken)(value == this.idTokenObject ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date expiresOnDate() {
        Object value = this.expiresOnDate.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.expiresOnDate;
            synchronized (atomicReference) {
                value = this.expiresOnDate.get();
                if (value == null) {
                    Date actualValue = new Date(this.expiresOn * 1000L);
                    value = actualValue == null ? this.expiresOnDate : actualValue;
                    this.expiresOnDate.set(value);
                }
            }
        }
        return (Date)(value == this.expiresOnDate ? null : value);
    }

    public static class AuthenticationResultBuilder {
        private String accessToken;
        private long expiresOn;
        private long extExpiresOn;
        private String refreshToken;
        private String idToken;
        private Account account;
        private String environment;
        private String scopes;

        AuthenticationResultBuilder() {
        }

        public AuthenticationResultBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AuthenticationResultBuilder expiresOn(long expiresOn) {
            this.expiresOn = expiresOn;
            return this;
        }

        public AuthenticationResultBuilder extExpiresOn(long extExpiresOn) {
            this.extExpiresOn = extExpiresOn;
            return this;
        }

        public AuthenticationResultBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AuthenticationResultBuilder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public AuthenticationResultBuilder account(Account account) {
            this.account = account;
            return this;
        }

        public AuthenticationResultBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public AuthenticationResultBuilder scopes(String scopes) {
            this.scopes = scopes;
            return this;
        }

        public AuthenticationResult build() {
            return new AuthenticationResult(this.accessToken, this.expiresOn, this.extExpiresOn, this.refreshToken, this.idToken, this.account, this.environment, this.scopes);
        }

        public String toString() {
            return "AuthenticationResult.AuthenticationResultBuilder(accessToken=" + this.accessToken + ", expiresOn=" + this.expiresOn + ", extExpiresOn=" + this.extExpiresOn + ", refreshToken=" + this.refreshToken + ", idToken=" + this.idToken + ", account=" + this.account + ", environment=" + this.environment + ", scopes=" + this.scopes + ")";
        }
    }
}

