/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.Authority;
import java.net.URL;

class AADAuthority
extends Authority {
    private static final String TENANTLESS_TENANT_NAME = "common";
    private final String AADAuthorityFormat = "https://%s/%s/";
    final String AADtokenEndpointFormat = "https://%s/{tenant}/oauth2/v2.0/token";
    static final String DEVICE_CODE_ENDPOINT = "/oauth2/v2.0/devicecode";
    final String deviceCodeEndpointFormat = "https://%s/{tenant}/oauth2/v2.0/devicecode";
    String deviceCodeEndpoint;

    AADAuthority(URL authorityUrl) {
        super(authorityUrl);
        this.validateAuthorityUrl();
        this.setAuthorityProperties();
        this.authority = String.format("https://%s/%s/", this.host, this.tenant);
    }

    private void setAuthorityProperties() {
        this.tokenEndpoint = String.format("https://%s/{tenant}/oauth2/v2.0/token", this.host);
        this.tokenEndpoint = this.tokenEndpoint.replace("{tenant}", this.tenant);
        this.deviceCodeEndpoint = String.format(this.deviceCodeEndpointFormat, this.host);
        this.deviceCodeEndpoint = this.deviceCodeEndpoint.replace("{tenant}", this.tenant);
        this.isTenantless = TENANTLESS_TENANT_NAME.equalsIgnoreCase(this.tenant);
        this.selfSignedJwtAudience = this.tokenEndpoint;
    }

    String AADAuthorityFormat() {
        return this.AADAuthorityFormat;
    }

    String AADtokenEndpointFormat() {
        return this.AADtokenEndpointFormat;
    }

    String deviceCodeEndpointFormat() {
        return this.deviceCodeEndpointFormat;
    }

    String deviceCodeEndpoint() {
        return this.deviceCodeEndpoint;
    }
}

