/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.exceptions.KustoDataExceptionBase;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;
import reactor.util.retry.Retry;

public class ExponentialRetry {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int maxAttempts;
    double sleepBaseSecs;
    double maxJitterSecs;

    public ExponentialRetry(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = 1.0;
        this.maxJitterSecs = 1.0;
    }

    public ExponentialRetry(int maxAttempts, double sleepBaseSecs, double maxJitterSecs) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = sleepBaseSecs;
        this.maxJitterSecs = maxJitterSecs;
    }

    public ExponentialRetry(ExponentialRetry other) {
        this.maxAttempts = other.maxAttempts;
        this.sleepBaseSecs = other.sleepBaseSecs;
        this.maxJitterSecs = other.maxJitterSecs;
    }

    public Retry retry(@Nullable List<Class<? extends Throwable>> retriableErrorClasses, @Nullable Predicate<? super Throwable> filter) {
        if (retriableErrorClasses != null && filter != null) {
            throw new IllegalArgumentException("Cannot specify both retriableErrorClasses and filter");
        }
        Predicate<? super Throwable> filterToUse = filter == null ? throwable -> ExponentialRetry.shouldRetry(throwable, retriableErrorClasses) : filter;
        return Retry.backoff((long)this.maxAttempts, (Duration)Duration.ofSeconds((long)this.sleepBaseSecs)).maxBackoff(Duration.ofSeconds(30L)).jitter(this.maxJitterSecs).filter(filterToUse).doAfterRetry(retrySignal -> {
            long currentAttempt = retrySignal.totalRetries() + 1L;
            log.info("Attempt {} failed.", (Object)currentAttempt);
        }).onRetryExhaustedThrow((spec, signal) -> signal.failure());
    }

    private static boolean shouldRetry(Throwable failure, List<Class<? extends Throwable>> retriableErrorClasses) {
        if (failure instanceof KustoDataExceptionBase) {
            return !((KustoDataExceptionBase)((Object)failure)).isPermanent();
        }
        if (retriableErrorClasses != null) {
            return retriableErrorClasses.stream().anyMatch(errorClass -> errorClass.isInstance(failure));
        }
        return false;
    }
}

