/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.BatchOperation;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.KeepAliveSocketFactory;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public final class BaseRequest {
    private static final String METADATA = "metadata";
    private static final String SERVICE = "service";
    private static final String STATS = "stats";
    private static final String TIMEOUT = "timeout";
    private static final String ACCOUNT = "account";
    private static final String USER_DELEGATION_KEY = "userdelegationkey";
    private static final String BATCH_QUERY_ELEMENT_NAME = "batch";
    private static final String HTTP_LINE_ENDING = "\r\n";
    private static String userAgent;

    public static void addMetadata(HttpURLConnection request, Map<String, String> metadata, OperationContext opContext) {
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                BaseRequest.addMetadata(request, entry.getKey(), entry.getValue(), opContext);
            }
        }
    }

    private static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        if (Utility.isNullOrEmptyOrWhitespace(name)) {
            throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        if (Utility.isNullOrEmptyOrWhitespace(value)) {
            throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        request.setRequestProperty("x-ms-meta-" + name, value);
    }

    public static void addOptionalHeader(HttpURLConnection request, String name, String value) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(name, value);
        }
    }

    public static HttpURLConnection create(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection createURLConnection(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection;
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        if (options.getTimeoutIntervalInMs() != null && options.getTimeoutIntervalInMs() != 0) {
            builder.add(TIMEOUT, String.valueOf(options.getTimeoutIntervalInMs() / 1000));
        }
        URL resourceUrl = builder.addToURI(uri).toURL();
        Proxy proxy = OperationContext.getDefaultProxy();
        String username = OperationContext.getDefaultProxyUsername();
        String password = OperationContext.getDefaultProxyPassword();
        if (opContext != null && opContext.getProxy() != null) {
            proxy = opContext.getProxy();
            if (opContext.getProxyUsername() != null) {
                username = opContext.getProxyUsername();
            }
            if (opContext.getProxyPassword() != null) {
                password = opContext.getProxyPassword();
            }
        }
        if (proxy != null) {
            retConnection = (HttpURLConnection)resourceUrl.openConnection(proxy);
            if (username != null && password != null) {
                String authString = "Basic " + Utility.safeEncode(username + ":" + password);
                final String authUsername = username;
                final String authPassword = password;
                retConnection.setRequestProperty("Proxy-Authorization", authString);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        PasswordAuthentication passwordAuthentication = new PasswordAuthentication(authUsername, authPassword.toCharArray());
                        return passwordAuthentication;
                    }
                });
            }
        } else {
            retConnection = (HttpURLConnection)resourceUrl.openConnection();
        }
        if (retConnection instanceof HttpsURLConnection && !options.disableHttpsSocketKeepAlive().booleanValue()) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)retConnection;
            httpsConnection.setSSLSocketFactory(new KeepAliveSocketFactory(httpsConnection.getSSLSocketFactory()));
        }
        int timeout = Utility.getRemainingTimeout(options.getOperationExpiryTimeInMs(), options.getTimeoutIntervalInMs());
        retConnection.setReadTimeout(timeout);
        retConnection.setConnectTimeout(timeout);
        retConnection.setRequestProperty("Accept", "application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF-8");
        retConnection.setRequestProperty("Content-Type", "");
        retConnection.setRequestProperty("x-ms-version", "2019-02-02");
        retConnection.setRequestProperty("User-Agent", BaseRequest.getUserAgent());
        retConnection.setRequestProperty("x-ms-client-request-id", opContext.getClientRequestID());
        return retConnection;
    }

    public static HttpURLConnection delete(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("DELETE");
        return retConnection;
    }

    public static HttpURLConnection undelete(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "undelete");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static UriQueryBuilder getListUriQueryBuilder(ListingContext listingContext) throws StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        return builder;
    }

    public static HttpURLConnection getProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static HttpURLConnection getServiceStats(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", STATS);
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static HttpURLConnection getAccountInfo(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("restype", ACCOUNT);
        builder.add("comp", "properties");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            String userAgentComment = String.format(Utility.LOCALE_US, "(JavaJRE %s; %s %s)", System.getProperty("java.version"), System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"));
            userAgent = String.format("%s/%s %s", "Azure-Storage", "8.6.2", userAgentComment);
        }
        return userAgent;
    }

    public static HttpURLConnection setMetadata(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection setServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection getUserDelegationKey(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", USER_DELEGATION_KEY);
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("POST");
        return retConnection;
    }

    public static HttpURLConnection batch(URI uri, RequestOptions options, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BATCH_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, options, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("POST");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
            accessCondition.applyAppendConditionToRequest(request);
        }
        return request;
    }

    public static <C extends ServiceClient, P, R> byte[] buildBatchBody(C client, BatchOperation<C, P, R> batch, OperationContext opContext) throws Exception {
        byte[] delim = ("--batch_" + batch.getBatchId() + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8);
        byte[] contentTypeHeader = "Content-Type: application/http\r\n".getBytes(StandardCharsets.UTF_8);
        byte[] newlineBytes = HTTP_LINE_ENDING.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int contentId = 0;
        for (Map.Entry<StorageRequest<C, P, R>, P> subRequest : batch) {
            subRequest.getKey().initializeLocation();
            HttpURLConnection builtRequest = BaseRequest.copyRequestForBatch(subRequest.getKey().buildRequest(client, subRequest.getValue(), opContext));
            subRequest.getKey().setHeaders(builtRequest, subRequest.getValue(), opContext);
            String authValue = StorageRequest.signBlobQueueAndFileRequest(builtRequest, client, -1L, opContext);
            stream.write(delim);
            stream.write(contentTypeHeader);
            stream.write(("Content-ID: " + contentId++ + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
            if (builtRequest.getRequestProperties().get("Content-Transfer-Encoding") != null) {
                stream.write(("Content-Transfer-Encoding: " + builtRequest.getRequestProperties().get("Content-Transfer-Encoding") + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
            }
            stream.write(newlineBytes);
            String requestMethod = builtRequest.getRequestMethod();
            String path = builtRequest.getURL().getPath();
            String query = builtRequest.getURL().getQuery();
            query = query == null ? "" : "?" + query;
            stream.write((requestMethod + " " + path + query + " HTTP/1.1" + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
            for (Map.Entry<String, List<String>> header : builtRequest.getRequestProperties().entrySet()) {
                stream.write((header.getKey() + ": " + Utility.stringJoin((CharSequence)",", (Iterable<String>)header.getValue()) + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
            }
            stream.write(("Authorization: " + authValue + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
            stream.write(newlineBytes);
        }
        stream.write(("--batch_" + batch.getBatchId() + "--" + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
        return stream.toByteArray();
    }

    private static HttpURLConnection copyRequestForBatch(HttpURLConnection connection) {
        HttpURLConnection result;
        try {
            result = (HttpURLConnection)connection.getURL().openConnection();
            result.setRequestMethod(connection.getRequestMethod());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            if (header.getKey().equals("x-ms-version") || header.getKey().equals("Content-Type") || header.getKey().equals("Content-Transfer-Encoding")) continue;
            result.setRequestProperty(header.getKey(), Utility.stringJoin((CharSequence)",", (Iterable<String>)header.getValue()));
        }
        return result;
    }

    private BaseRequest() {
    }
}

