/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.queue;

import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.EncryptionAgent;
import com.microsoft.azure.storage.core.EncryptionAlgorithm;
import com.microsoft.azure.storage.core.EncryptionData;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.core.WrappedContentKey;
import com.microsoft.azure.storage.queue.CloudQueueEncryptedMessage;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.tuple.Pair;

public final class QueueEncryptionPolicy {
    public IKey keyWrapper;
    public IKeyResolver keyResolver;

    public QueueEncryptionPolicy(IKey key, IKeyResolver keyResolver) {
        this.keyWrapper = key;
        this.keyResolver = keyResolver;
    }

    public IKey getKey() {
        return this.keyWrapper;
    }

    public IKeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKey(IKey key) {
        this.keyWrapper = key;
    }

    public void setKeyResolver(IKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    String encryptMessage(byte[] inputMessage) throws StorageException {
        Utility.assertNotNull("inputMessage", inputMessage);
        if (this.keyWrapper == null) {
            throw new IllegalArgumentException("Key is not initialized. Encryption requires it to be initialized.");
        }
        CloudQueueEncryptedMessage encryptedMessage = new CloudQueueEncryptedMessage();
        EncryptionData encryptionData = new EncryptionData();
        if (encryptionData.getKeyWrappingMetadata() == null) {
            encryptionData.setKeyWrappingMetadata(new HashMap<String, String>());
        }
        encryptionData.getKeyWrappingMetadata().put("EncryptionLibrary", "Java 8.2.0");
        encryptionData.setEncryptionAgent(new EncryptionAgent("1.0", EncryptionAlgorithm.AES_CBC_256));
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            Cipher myAes = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKey aesKey = keyGen.generateKey();
            myAes.init(1, aesKey);
            Pair encryptedKey = (Pair)this.keyWrapper.wrapKeyAsync(aesKey.getEncoded(), null).get();
            encryptionData.setWrappedContentKey(new WrappedContentKey(this.keyWrapper.getKid(), (byte[])encryptedKey.getKey(), (String)encryptedKey.getValue()));
            encryptedMessage.setEncryptedMessageContents(new String(Base64.encode(myAes.doFinal(inputMessage, 0, inputMessage.length))));
            encryptionData.setContentEncryptionIV(myAes.getIV());
            encryptedMessage.setEncryptionData(encryptionData);
            return encryptedMessage.serialize();
        }
        catch (Exception e) {
            throw StorageException.translateClientException(e);
        }
    }

    byte[] decryptMessage(String inputMessage, Boolean requireEncryption) throws StorageException {
        Utility.assertNotNull("inputMessage", inputMessage);
        try {
            CloudQueueEncryptedMessage encryptedMessage = CloudQueueEncryptedMessage.deserialize(inputMessage);
            if (requireEncryption != null && requireEncryption.booleanValue() && encryptedMessage.getEncryptionData() == null) {
                throw new StorageException("DecryptionError", "Encryption data does not exist. If you do not want to decrypt the data, please do not set the require encryption flag on request options", null);
            }
            if (encryptedMessage.getEncryptionData() != null) {
                EncryptionData encryptionData = encryptedMessage.getEncryptionData();
                Utility.assertNotNull("contentEncryptionIV", encryptionData.getContentEncryptionIV());
                Utility.assertNotNull("encryptedKey", encryptionData.getWrappedContentKey().getEncryptedKey());
                if (!"1.0".equals(encryptionData.getEncryptionAgent().getProtocol())) {
                    throw new StorageException("DecryptionError", "Invalid Encryption Agent. This version of the client library does not understand the Encryption Agent set on the blob.", null);
                }
                if (this.keyWrapper == null && this.keyResolver == null) {
                    throw new StorageException("DecryptionError", "Key and Resolver are not initialized. Decryption requires either of them to be initialized.", null);
                }
                byte[] contentEncryptionKey = null;
                if (this.keyResolver != null) {
                    IKey keyEncryptionKey = (IKey)this.keyResolver.resolveKeyAsync(encryptionData.getWrappedContentKey().getKeyId()).get();
                    Utility.assertNotNull("keyEncryptionKey", keyEncryptionKey);
                    contentEncryptionKey = (byte[])keyEncryptionKey.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
                } else if (encryptionData.getWrappedContentKey().getKeyId().equals(this.keyWrapper.getKid())) {
                    contentEncryptionKey = (byte[])this.keyWrapper.unwrapKeyAsync(encryptionData.getWrappedContentKey().getEncryptedKey(), encryptionData.getWrappedContentKey().getAlgorithm()).get();
                } else {
                    throw new StorageException("DecryptionError", "Key mismatch. The key id stored on the service does not match the specified key.", null);
                }
                switch (encryptionData.getEncryptionAgent().getEncryptionAlgorithm()) {
                    case AES_CBC_256: {
                        Cipher myAes = Cipher.getInstance("AES/CBC/PKCS5Padding");
                        IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptionData.getContentEncryptionIV());
                        SecretKeySpec keySpec = new SecretKeySpec(contentEncryptionKey, 0, contentEncryptionKey.length, "AES");
                        myAes.init(2, (Key)keySpec, ivParameterSpec);
                        byte[] src = Base64.decode(encryptedMessage.getEncryptedMessageContents());
                        return myAes.doFinal(src, 0, src.length);
                    }
                }
                throw new StorageException("DecryptionError", "Invalid Encryption Algorithm found on the resource. This version of the client library does not support the specified encryption algorithm.", null);
            }
            return Base64.decode(encryptedMessage.getEncryptedMessageContents());
        }
        catch (StorageException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new StorageException("DecryptionError", "Decryption logic threw error. Please check the inner exception for more details.", ex);
        }
    }
}

