/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.SharedAccessPolicy;
import com.microsoft.azure.storage.file.SharedAccessFilePermissions;
import java.util.EnumSet;

public final class SharedAccessFilePolicy
extends SharedAccessPolicy {
    private EnumSet<SharedAccessFilePermissions> permissions;

    public EnumSet<SharedAccessFilePermissions> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(EnumSet<SharedAccessFilePermissions> permissions) {
        this.permissions = permissions;
    }

    @Override
    public String permissionsToString() {
        if (this.permissions == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.permissions.contains((Object)SharedAccessFilePermissions.READ)) {
            builder.append("r");
        }
        if (this.permissions.contains((Object)SharedAccessFilePermissions.WRITE)) {
            builder.append("w");
        }
        if (this.permissions.contains((Object)SharedAccessFilePermissions.DELETE)) {
            builder.append("d");
        }
        if (this.permissions.contains((Object)SharedAccessFilePermissions.LIST)) {
            builder.append("l");
        }
        return builder.toString();
    }

    @Override
    public void setPermissionsFromString(String value) {
        EnumSet<SharedAccessFilePermissions> initial = EnumSet.noneOf(SharedAccessFilePermissions.class);
        block6: for (char c : value.toCharArray()) {
            switch (c) {
                case 'r': {
                    initial.add(SharedAccessFilePermissions.READ);
                    continue block6;
                }
                case 'w': {
                    initial.add(SharedAccessFilePermissions.WRITE);
                    continue block6;
                }
                case 'd': {
                    initial.add(SharedAccessFilePermissions.DELETE);
                    continue block6;
                }
                case 'l': {
                    initial.add(SharedAccessFilePermissions.LIST);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("value");
                }
            }
        }
        this.permissions = initial;
    }
}

