/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobExecutionInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobTargetExecutionsInner {
    private JobTargetExecutionsService service;
    private SqlManagementClientImpl client;

    public JobTargetExecutionsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobTargetExecutionsService)retrofit.create(JobTargetExecutionsService.class);
        this.client = client;
    }

    public PagedList<JobExecutionInner> listByJobExecution(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        ServiceResponse response = (ServiceResponse)this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobExecutionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.listByJobExecutionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        DateTime createTimeMin = null;
        DateTime createTimeMax = null;
        DateTime endTimeMin = null;
        DateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return this.service.listByJobExecution(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByJobExecutionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobExecutionInner> listByJobExecution(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobExecutionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByJobExecutionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByJobExecutionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByJobExecution(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByJobExecutionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobExecutionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByStep(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName) {
        ServiceResponse response = (ServiceResponse)this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByStepAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByStepAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName) {
        return this.listByStepWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName) {
        return this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByStepNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        DateTime createTimeMin = null;
        DateTime createTimeMax = null;
        DateTime endTimeMin = null;
        DateTime endTimeMax = null;
        Boolean isActive = null;
        Integer skip = null;
        Integer top = null;
        return this.service.listByStep(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByStepDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobExecutionInner> listByStep(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByStepAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByStepAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByStepWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        return this.listByStepSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByStepNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, DateTime createTimeMin, DateTime createTimeMax, DateTime endTimeMin, DateTime endTimeMax, Boolean isActive, Integer skip, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByStep(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, this.client.subscriptionId(), createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByStepDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByStepDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        return (JobExecutionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId).toBlocking().single()).body());
    }

    public ServiceFuture<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId, ServiceCallback<JobExecutionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId), serviceCallback);
    }

    public Observable<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId).map((Func1)new Func1<ServiceResponse<JobExecutionInner>, JobExecutionInner>(){

            public JobExecutionInner call(ServiceResponse<JobExecutionInner> response) {
                return (JobExecutionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobExecutionInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, String stepName, UUID targetId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (jobExecutionId == null) {
            throw new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("Parameter targetId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, stepName, targetId, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobExecutionInner>>>(){

            public Observable<ServiceResponse<JobExecutionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobTargetExecutionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobExecutionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobExecutionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByJobExecutionNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByJobExecutionNextAsync(String nextPageLink, ServiceFuture<List<JobExecutionInner>> serviceFuture, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobExecutionNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByJobExecutionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByJobExecutionNextAsync(String nextPageLink) {
        return this.listByJobExecutionNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByJobExecutionNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByJobExecutionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByJobExecutionNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByJobExecutionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByJobExecutionNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByJobExecutionNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobExecutionInner> listByStepNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByStepNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobExecutionInner>((Page)response.body()){

            public Page<JobExecutionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobExecutionInner>> listByStepNextAsync(String nextPageLink, ServiceFuture<List<JobExecutionInner>> serviceFuture, ListOperationCallback<JobExecutionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByStepNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(String nextPageLink) {
                return JobTargetExecutionsInner.this.listByStepNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobExecutionInner>> listByStepNextAsync(String nextPageLink) {
        return this.listByStepNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Page<JobExecutionInner>>(){

            public Page<JobExecutionInner> call(ServiceResponse<Page<JobExecutionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByStepNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobExecutionInner>>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(ServiceResponse<Page<JobExecutionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobTargetExecutionsInner.this.listByStepNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobExecutionInner>>> listByStepNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByStepNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobExecutionInner>>>>(){

            public Observable<ServiceResponse<Page<JobExecutionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobTargetExecutionsInner.this.listByStepNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobExecutionInner>> listByStepNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobExecutionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobTargetExecutionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByJobExecution"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/targets")
        public Observable<Response<ResponseBody>> listByJobExecution(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="subscriptionId") String var6, @Query(value="createTimeMin") DateTime var7, @Query(value="createTimeMax") DateTime var8, @Query(value="endTimeMin") DateTime var9, @Query(value="endTimeMax") DateTime var10, @Query(value="isActive") Boolean var11, @Query(value="$skip") Integer var12, @Query(value="$top") Integer var13, @Query(value="api-version") String var14, @Header(value="accept-language") String var15, @Header(value="User-Agent") String var16);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByStep"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets")
        public Observable<Response<ResponseBody>> listByStep(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="stepName") String var6, @Path(value="subscriptionId") String var7, @Query(value="createTimeMin") DateTime var8, @Query(value="createTimeMax") DateTime var9, @Query(value="endTimeMin") DateTime var10, @Query(value="endTimeMax") DateTime var11, @Query(value="isActive") Boolean var12, @Query(value="$skip") Integer var13, @Query(value="$top") Integer var14, @Query(value="api-version") String var15, @Header(value="accept-language") String var16, @Header(value="User-Agent") String var17);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/steps/{stepName}/targets/{targetId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobExecutionId") UUID var5, @Path(value="stepName") String var6, @Path(value="targetId") UUID var7, @Path(value="subscriptionId") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByJobExecutionNext"})
        @GET
        public Observable<Response<ResponseBody>> listByJobExecutionNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobTargetExecutions listByStepNext"})
        @GET
        public Observable<Response<ResponseBody>> listByStepNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

