/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers.runtime;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.appservice.DockerImageType;
import com.microsoft.azure.maven.function.handlers.runtime.AbstractLinuxFunctionRuntimeHandler;
import com.microsoft.azure.maven.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.maven.utils.AppServiceUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class DockerFunctionRuntimeHandler
extends AbstractLinuxFunctionRuntimeHandler {
    private static final String INVALID_DOCKER_RUNTIME = "Invalid docker runtime configured.";

    protected DockerFunctionRuntimeHandler(Builder builder) {
        super((FunctionRuntimeHandler.Builder)builder);
    }

    @Override
    public FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException {
        FunctionApp.DefinitionStages.WithCreate result;
        Server server = Utils.getServer((Settings)this.settings, (String)this.serverId);
        DockerImageType imageType = AppServiceUtils.getDockerImageType((String)this.image, (String)this.serverId, (String)this.registryUrl);
        this.checkFunctionExtensionVersion();
        this.checkConfiguration(imageType, server);
        FunctionApp.DefinitionStages.WithDockerContainerImage withDockerContainerImage = super.defineLinuxFunction();
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                result = withDockerContainerImage.withPublicDockerHubImage(this.image);
                break;
            }
            case PRIVATE_DOCKER_HUB: {
                result = withDockerContainerImage.withPrivateDockerHubImage(this.image).withCredentials(server.getUsername(), server.getPassword());
                break;
            }
            case PRIVATE_REGISTRY: {
                result = withDockerContainerImage.withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(server.getUsername(), server.getPassword());
                break;
            }
            default: {
                throw new AzureExecutionException(INVALID_DOCKER_RUNTIME);
            }
        }
        String decryptionKey = this.generateDecryptionKey();
        return (FunctionApp.DefinitionStages.WithCreate)result.withAppSetting("MACHINEKEY_DecryptionKey", decryptionKey).withAppSetting("WEBSITES_ENABLE_APP_SERVICE_STORAGE", "false").withAppSetting("FUNCTION_APP_EDIT_MODE", "readOnly");
    }

    @Override
    public FunctionApp.Update updateAppRuntime(FunctionApp app) throws AzureExecutionException {
        Server server = Utils.getServer((Settings)this.settings, (String)this.serverId);
        DockerImageType imageType = AppServiceUtils.getDockerImageType((String)this.image, (String)this.serverId, (String)this.registryUrl);
        this.checkFunctionExtensionVersion();
        this.checkConfiguration(imageType, server);
        FunctionApp.Update update = (FunctionApp.Update)app.update();
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                return update.withPublicDockerHubImage(this.image);
            }
            case PRIVATE_DOCKER_HUB: {
                return update.withPrivateDockerHubImage(this.image).withCredentials(server.getUsername(), server.getPassword());
            }
            case PRIVATE_REGISTRY: {
                return update.withPrivateRegistryImage(this.image, this.registryUrl).withCredentials(server.getUsername(), server.getPassword());
            }
        }
        throw new AzureExecutionException(INVALID_DOCKER_RUNTIME);
    }

    protected void checkConfiguration(DockerImageType imageType, Server server) throws AzureExecutionException {
        if (imageType != DockerImageType.PUBLIC_DOCKER_HUB) {
            Utils.assureServerExist((Server)server, (String)this.serverId);
        }
        if (this.pricingTier == null) {
            throw new AzureExecutionException("Consumption plan is not supported for docker functions");
        }
    }

    protected String generateDecryptionKey() {
        return Hex.encodeHexString((byte[])RandomUtils.nextBytes((int)32)).toUpperCase();
    }

    public static class Builder
    extends FunctionRuntimeHandler.Builder<Builder> {
        @Override
        public DockerFunctionRuntimeHandler build() {
            return new DockerFunctionRuntimeHandler(this.self());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

