/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.microsoft.azure.maven.function.handlers.CommandHandler;
import com.microsoft.azure.maven.function.utils.CommandUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class CommandHandlerImpl
implements CommandHandler {
    private Log logger;

    public CommandHandlerImpl(Log logger) {
        this.logger = logger;
    }

    @Override
    public void runCommandWithReturnCodeCheck(String command, boolean showStdout, String workingDirectory, List<Long> validReturnCodes, String errorMessage) throws Exception {
        Process process = this.runCommand(command, showStdout, workingDirectory);
        this.handleExitValue(process.exitValue(), validReturnCodes, errorMessage, process.getInputStream());
    }

    @Override
    public String runCommandAndGetOutput(String command, boolean showStdout, String workingDirectory) throws Exception {
        Process process = this.runCommand(command, showStdout, workingDirectory);
        return this.getOutputFromProcess(process);
    }

    protected String getOutputFromProcess(Process process) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));){
            StringBuffer stdout = new StringBuffer();
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                stdout.append(s);
            }
            String string = stdout.toString().trim();
            return string;
        }
    }

    protected Process runCommand(String command, boolean showStdout, String workingDirectory) throws Exception {
        this.logger.debug((CharSequence)("Executing command: " + StringUtils.join((Object[])new String[]{command, " "})));
        ProcessBuilder.Redirect redirect = CommandHandlerImpl.getStdoutRedirect(showStdout);
        ProcessBuilder processBuilder = new ProcessBuilder(CommandHandlerImpl.buildCommand(command)).redirectOutput(redirect).redirectErrorStream(true);
        if (workingDirectory != null) {
            processBuilder.directory(new File(workingDirectory));
        }
        Process process = processBuilder.start();
        process.waitFor();
        return process;
    }

    protected static String[] buildCommand(String command) {
        String[] stringArray;
        if (CommandUtils.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd.exe";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = command;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = command;
        }
        return stringArray;
    }

    protected static ProcessBuilder.Redirect getStdoutRedirect(boolean showStdout) {
        return showStdout ? ProcessBuilder.Redirect.INHERIT : ProcessBuilder.Redirect.PIPE;
    }

    protected void handleExitValue(int exitValue, List<Long> validReturnCodes, String errorMessage, InputStream inputStream) throws Exception {
        this.logger.debug((CharSequence)("Process exit value: " + exitValue));
        if (!validReturnCodes.contains(Integer.toUnsignedLong(exitValue))) {
            this.showErrorIfAny(inputStream);
            this.logger.error((CharSequence)errorMessage);
            throw new Exception(errorMessage);
        }
    }

    protected void showErrorIfAny(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            String input = IOUtils.toString((InputStream)inputStream, (String)"utf8");
            this.logger.error((CharSequence)StringUtils.strip((String)input, (String)"\n"));
        }
    }
}

