/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.microsoft.azure.functions.annotation.FunctionName;
import com.microsoft.azure.functions.annotation.StorageAccount;
import com.microsoft.azure.maven.function.bindings.Binding;
import com.microsoft.azure.maven.function.bindings.BindingEnum;
import com.microsoft.azure.maven.function.bindings.BindingFactory;
import com.microsoft.azure.maven.function.configurations.FunctionConfiguration;
import com.microsoft.azure.maven.function.handlers.AnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class AnnotationHandlerImpl
implements AnnotationHandler {
    protected Log log;

    public AnnotationHandlerImpl(Log log) {
        this.log = log;
    }

    @Override
    public Set<Method> findFunctions(List<URL> urls) {
        return new Reflections((Configuration)new ConfigurationBuilder().addUrls(urls).setScanners(new Scanner[]{new MethodAnnotationsScanner()}).addClassLoader(this.getClassLoader(urls))).getMethodsAnnotatedWith(FunctionName.class);
    }

    protected ClassLoader getClassLoader(List<URL> urlList) {
        URL[] urlArray = urlList.toArray(new URL[urlList.size()]);
        return new URLClassLoader(urlArray, this.getClass().getClassLoader());
    }

    @Override
    public Map<String, FunctionConfiguration> generateConfigurations(Set<Method> methods) throws Exception {
        HashMap<String, FunctionConfiguration> configMap = new HashMap<String, FunctionConfiguration>();
        for (Method method : methods) {
            FunctionName functionAnnotation = method.getAnnotation(FunctionName.class);
            String functionName = functionAnnotation.value();
            this.validateFunctionName(configMap.keySet(), functionName);
            this.log.debug((CharSequence)("Starting processing function : " + functionName));
            configMap.put(functionName, this.generateConfiguration(method));
        }
        return configMap;
    }

    protected void validateFunctionName(Set<String> nameSet, String functionName) throws Exception {
        if (StringUtils.isEmpty((CharSequence)functionName)) {
            throw new Exception("Azure Functions name cannot be empty.");
        }
        if (nameSet.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n, (CharSequence)functionName))) {
            throw new Exception("Found duplicate Azure Function: " + functionName);
        }
    }

    @Override
    public FunctionConfiguration generateConfiguration(Method method) {
        FunctionConfiguration config = new FunctionConfiguration();
        List<Binding> bindings = config.getBindings();
        this.processParameterAnnotations(method, bindings);
        this.processMethodAnnotations(method, bindings);
        this.patchStorageBinding(method, bindings);
        config.setEntryPoint(method.getDeclaringClass().getCanonicalName() + "." + method.getName());
        return config;
    }

    protected void processParameterAnnotations(Method method, List<Binding> bindings) {
        for (Parameter param : method.getParameters()) {
            bindings.addAll(this.parseAnnotations(param::getAnnotations, this::parseParameterAnnotation));
        }
    }

    protected void processMethodAnnotations(Method method, List<Binding> bindings) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            bindings.addAll(this.parseAnnotations(method::getAnnotations, this::parseMethodAnnotation));
            if (bindings.stream().anyMatch(b -> b.getBindingEnum() == BindingEnum.HttpTrigger) && bindings.stream().noneMatch(b -> b.getName().equalsIgnoreCase("$return"))) {
                bindings.add(BindingFactory.getHTTPOutBinding());
            }
        }
    }

    protected List<Binding> parseAnnotations(Supplier<Annotation[]> annotationProvider, Function<Annotation, Binding> annotationParser) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Annotation annotation : annotationProvider.get()) {
            Binding binding = annotationParser.apply(annotation);
            if (binding == null) continue;
            this.log.debug((CharSequence)("Adding binding: " + binding.toString()));
            bindings.add(binding);
        }
        return bindings;
    }

    protected Binding parseParameterAnnotation(Annotation annotation) {
        return BindingFactory.getBinding(annotation);
    }

    protected Binding parseMethodAnnotation(Annotation annotation) {
        Binding ret = this.parseParameterAnnotation(annotation);
        if (ret != null) {
            ret.setName("$return");
        }
        return ret;
    }

    protected void patchStorageBinding(Method method, List<Binding> bindings) {
        Optional<Annotation> storageAccount = Arrays.stream(method.getAnnotations()).filter(annotation -> annotation instanceof StorageAccount).findFirst();
        if (storageAccount.isPresent()) {
            this.log.debug((CharSequence)"StorageAccount annotation found.");
            String connectionString = ((StorageAccount)storageAccount.get()).value();
            bindings.stream().filter(binding -> binding.getBindingEnum().isStorage()).filter(binding -> StringUtils.isEmpty((CharSequence)((String)binding.getAttribute("connection")))).forEach(binding -> binding.setAttribute("connection", connectionString));
        } else {
            this.log.debug((CharSequence)"No StorageAccount annotation found.");
        }
    }
}

