/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.maven.function.utils.DateUtils;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.EnumSet;

public class AzureStorageHelper {
    private static final int SAS_START_RESERVE_MINUTE = 5;
    private static final String FAIL_TO_GENERATE_BLOB_SAS_TOKEN = "Fail to generate blob sas token";

    public static CloudBlockBlob uploadFileAsBlob(File fileToUpload, CloudStorageAccount storageAccount, String containerName, String blobName) throws Exception {
        CloudBlobContainer blobContainer = AzureStorageHelper.getBlobContainer(storageAccount, containerName);
        blobContainer.createIfNotExists(BlobContainerPublicAccessType.BLOB, null, null);
        CloudBlockBlob blob = blobContainer.getBlockBlobReference(blobName);
        blob.upload((InputStream)new FileInputStream(fileToUpload), fileToUpload.length());
        return blob;
    }

    public static void deleteBlob(CloudStorageAccount storageAccount, String containerName, String blobName) throws Exception {
        CloudBlobContainer blobContainer = AzureStorageHelper.getBlobContainer(storageAccount, containerName);
        if (blobContainer.exists()) {
            CloudBlockBlob blob = blobContainer.getBlockBlobReference(blobName);
            blob.deleteIfExists();
        }
    }

    public static String getSASToken(CloudBlob blob, Period period) throws AzureExecutionException {
        SharedAccessBlobPolicy policy = new SharedAccessBlobPolicy();
        policy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ));
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sasStartTime = now.minusMinutes(5L);
        LocalDateTime sasExpireTime = now.plus(period);
        policy.setSharedAccessStartTime(DateUtils.convertLocalDateTimeToDate(sasStartTime));
        policy.setSharedAccessExpiryTime(DateUtils.convertLocalDateTimeToDate(sasExpireTime));
        try {
            String sas = blob.generateSharedAccessSignature(policy, null);
            String url = blob.getUri().toString();
            return String.format("%s?%s", url, sas);
        }
        catch (StorageException | InvalidKeyException e) {
            throw new AzureExecutionException(FAIL_TO_GENERATE_BLOB_SAS_TOKEN, e);
        }
    }

    protected static CloudBlobContainer getBlobContainer(CloudStorageAccount storageAccount, String containerName) throws Exception {
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        return blobClient.getContainerReference(containerName);
    }
}

