/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.util;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;

public class FunctionUtils {
    private static final String STAGE_DIR_FOUND = "Azure Function App's staging directory found at: ";
    private static final String STAGE_DIR_NOT_FOUND = "Stage directory not found. Please run 'gradle azureFunctionsPackage first.";
    private static final String HOST_JSON_NOT_FOUND = "File 'host.json' cannot be found at staging directory.";
    private static final String LOCAL_SETTINGS_JSON_NOT_FOUND = "File 'local.settings.json' cannot be found at staging directory.";

    public static void checkStagingDirectory(String stagingFolder) throws AzureExecutionException {
        File file = new File(stagingFolder);
        if (!file.exists() || !file.isDirectory()) {
            throw new AzureExecutionException(STAGE_DIR_NOT_FOUND);
        }
        AzureMessager.getMessager().info(STAGE_DIR_FOUND + stagingFolder);
        File hostJson = new File(file, "host.json");
        if (!hostJson.exists() || !hostJson.isFile()) {
            throw new AzureExecutionException(HOST_JSON_NOT_FOUND);
        }
        File localSettingsJson = new File(file, "local.settings.json");
        if (!localSettingsJson.exists() || !localSettingsJson.isFile()) {
            throw new AzureExecutionException(LOCAL_SETTINGS_JSON_NOT_FOUND);
        }
    }
}

