/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.task;

import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.GradleFunctionContext;
import com.microsoft.azure.plugin.functions.gradle.task.IFunctionTask;
import com.microsoft.azure.plugin.functions.gradle.util.FunctionUtils;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.zeroturnaround.zip.ZipUtil;

public class PackageZipTask
extends DefaultTask
implements IFunctionTask {
    private static final String PACKAGE_ZIP_FAILURE = "Cannot build zip for azure functions due to error: ";
    @Nullable
    private AzureFunctionsExtension functionsExtension;

    @Override
    public IFunctionTask setFunctionsExtension(AzureFunctionsExtension functionsExtension) {
        this.functionsExtension = functionsExtension;
        return this;
    }

    @Override
    @Nested
    @Nullable
    public AzureFunctionsExtension getFunctionsExtension() {
        return this.functionsExtension;
    }

    @TaskAction
    public void buildZip() throws GradleException, IOException {
        try {
            TelemetryAgent.getInstance().trackTaskStart(this.getClass());
            GradleFunctionContext ctx = new GradleFunctionContext(this.getProject(), this.getFunctionsExtension());
            FunctionUtils.checkStagingDirectory(ctx.getDeploymentStagingDirectoryPath());
            File zipFile = new File(ctx.getDeploymentStagingDirectoryPath() + ".zip");
            ZipUtil.pack((File)new File(ctx.getDeploymentStagingDirectoryPath()), (File)zipFile);
            ZipUtil.removeEntry((File)zipFile, (String)"local.settings.json");
            AzureMessager.getMessager().info("Build zip from staging folder successfully: " + zipFile.getAbsolutePath());
            TelemetryAgent.getInstance().trackTaskSuccess(this.getClass());
        }
        catch (Exception e) {
            TelemetryAgent.getInstance().traceException(this.getClass(), e);
            throw new GradleException(PACKAGE_ZIP_FAILURE + e.getMessage(), (Throwable)e);
        }
    }
}

