/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.task;

import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.GradleFunctionContext;
import com.microsoft.azure.plugin.functions.gradle.handler.PackageHandler;
import com.microsoft.azure.plugin.functions.gradle.task.IFunctionTask;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;

public class PackageTask
extends DefaultTask
implements IFunctionTask {
    private static final String PACKAGE_FAILURE = "Cannot package functions due to error: ";
    @Nullable
    private AzureFunctionsExtension functionsExtension;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public IFunctionTask setFunctionsExtension(AzureFunctionsExtension functionsExtension) {
        this.functionsExtension = functionsExtension;
        return this;
    }

    @Override
    @Nested
    @Nullable
    public AzureFunctionsExtension getFunctionsExtension() {
        return this.functionsExtension;
    }

    @TaskAction
    @AzureOperation(name="user/functionapp.package")
    public void build() throws GradleException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                TelemetryAgent.getInstance().trackTaskStart(this.getClass());
                GradleFunctionContext ctx = new GradleFunctionContext(this.getProject(), this.getFunctionsExtension());
                TelemetryAgent.getInstance().addDefaultProperties(ctx.getTelemetryProperties());
                File stagingFolder = new File(ctx.getDeploymentStagingDirectoryPath());
                if (stagingFolder.exists()) {
                    FileUtils.cleanDirectory((File)stagingFolder);
                } else {
                    stagingFolder.mkdirs();
                }
                PackageHandler packageHandler = new PackageHandler(ctx.getProject(), ctx.getDeploymentStagingDirectoryPath());
                packageHandler.execute();
                TelemetryAgent.getInstance().trackTaskSuccess(this.getClass());
            }
            catch (Exception e) {
                TelemetryAgent.getInstance().traceException(this.getClass(), e);
                throw new GradleException(PACKAGE_FAILURE + e.getMessage(), (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        PackageTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PackageTask.java", PackageTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "build", "com.microsoft.azure.plugin.functions.gradle.task.PackageTask", "", "", "org.gradle.api.GradleException", "void"), 41);
    }
}

