/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.task;

import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.GradleFunctionContext;
import com.microsoft.azure.plugin.functions.gradle.task.IFunctionTask;
import com.microsoft.azure.plugin.functions.gradle.util.FunctionUtils;
import com.microsoft.azure.toolkit.lib.appservice.utils.FunctionCliResolver;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.CommandUtils;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class LocalRunTask
extends Exec
implements IFunctionTask {
    private static final String FUNC_CORE_CLI_NOT_FOUND = "Cannot run functions locally due to error: Azure Functions Core Tools can not be found.";
    private static final String JDWP_DEBUG_PREFIX = "-agentlib:jdwp=";
    private static final String DEFAULT_DEBUG_CONFIG = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005";
    private static final String RUN_FUNCTIONS_FAILURE = "Failed to run Azure Functions. Please checkout console output.";
    @Option(option="enableDebug", description="Enable debug when running functions")
    private Boolean enableDebug;
    @Nullable
    private AzureFunctionsExtension functionsExtension;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public IFunctionTask setFunctionsExtension(AzureFunctionsExtension functionsExtension) {
        this.functionsExtension = functionsExtension;
        return this;
    }

    @Override
    @Nested
    @Nullable
    public AzureFunctionsExtension getFunctionsExtension() {
        return this.functionsExtension;
    }

    public void setEnableDebug(Boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    @TaskAction
    @AzureOperation(name="user/functionapp.run")
    public void exec() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                block8: {
                    TelemetryAgent.getInstance().trackTaskStart(this.getClass());
                    GradleFunctionContext ctx = new GradleFunctionContext(this.getProject(), this.getFunctionsExtension());
                    String cliExec = FunctionCliResolver.resolveFunc();
                    if (StringUtils.isEmpty((CharSequence)cliExec)) {
                        throw new GradleException(FUNC_CORE_CLI_NOT_FOUND);
                    }
                    String stagingFolder = ctx.getDeploymentStagingDirectoryPath();
                    FunctionUtils.checkStagingDirectory(stagingFolder);
                    if (BooleanUtils.isTrue((Boolean)this.enableDebug) || StringUtils.isNotEmpty((CharSequence)ctx.getLocalDebugConfig())) {
                        this.commandLine(new Object[]{cliExec, "host", "start", "--language-worker", "--", LocalRunTask.getDebugJvmArgument(ctx.getLocalDebugConfig())});
                    } else {
                        this.commandLine(new Object[]{cliExec, "host", "start"});
                    }
                    this.setWorkingDir(new File(stagingFolder));
                    this.setIgnoreExitValue(true);
                    super.exec();
                    int code = this.getExecResult().getExitValue();
                    for (Long validCode : CommandUtils.getValidReturnCodes()) {
                        if (validCode == null || validCode.intValue() != code) continue;
                        break block8;
                    }
                    throw new GradleException(RUN_FUNCTIONS_FAILURE);
                }
                TelemetryAgent.getInstance().trackTaskSuccess(this.getClass());
            }
            catch (Exception e) {
                TelemetryAgent.getInstance().traceException(this.getClass(), e);
                throw new GradleException("Cannot run functions locally due to error:" + e.getMessage(), (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static String getDebugJvmArgument(String debugConfig) {
        if (StringUtils.isBlank((CharSequence)debugConfig)) {
            return DEFAULT_DEBUG_CONFIG;
        }
        if (debugConfig.contains(JDWP_DEBUG_PREFIX)) {
            return debugConfig;
        }
        return JDWP_DEBUG_PREFIX + debugConfig;
    }

    static {
        LocalRunTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LocalRunTask.java", LocalRunTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "exec", "com.microsoft.azure.plugin.functions.gradle.task.LocalRunTask", "", "", "", "void"), 61);
    }
}

