/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.task;

import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.GradleFunctionContext;
import com.microsoft.azure.plugin.functions.gradle.handler.DeployHandler;
import com.microsoft.azure.plugin.functions.gradle.task.IFunctionTask;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;

public class DeployTask
extends DefaultTask
implements IFunctionTask {
    private static final String PROXY = "proxy";
    private static final String DEPLOY_FAILURE = "Cannot deploy functions due to error: ";
    @Nullable
    private AzureFunctionsExtension functionsExtension;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public IFunctionTask setFunctionsExtension(AzureFunctionsExtension functionsExtension) {
        this.functionsExtension = functionsExtension;
        return this;
    }

    @Override
    @Nested
    @Nullable
    public AzureFunctionsExtension getFunctionsExtension() {
        return this.functionsExtension;
    }

    @TaskAction
    @AzureOperation(name="user/functionapp.deploy_app")
    public void deploy() throws GradleException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                ProxyManager.getInstance().applyProxy();
                TelemetryAgent.getInstance().addDefaultProperty(PROXY, String.valueOf(ProxyManager.getInstance().isProxyEnabled()));
                TelemetryAgent.getInstance().trackTaskStart(this.getClass());
                GradleFunctionContext ctx = new GradleFunctionContext(this.getProject(), this.getFunctionsExtension());
                TelemetryAgent.getInstance().addDefaultProperties(ctx.getTelemetryProperties());
                DeployHandler deployHandler = new DeployHandler(ctx);
                deployHandler.execute();
                TelemetryAgent.getInstance().trackTaskSuccess(this.getClass());
            }
            catch (Exception e) {
                AzureMessager.getMessager().error((Throwable)e);
                TelemetryAgent.getInstance().traceException(this.getClass(), e);
                throw new GradleException(DEPLOY_FAILURE + e.getMessage(), (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        DeployTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployTask.java", DeployTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "com.microsoft.azure.plugin.functions.gradle.task.DeployTask", "", "", "org.gradle.api.GradleException", "void"), 44);
    }
}

