/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.telemetry.Preconditions;
import java.util.Objects;

public final class Duration {
    private static final long SECONDS_IN_ONE_MINUTE = 60L;
    private static final long SECONDS_IN_ONE_HOUR = 3600L;
    private static final long SECONDS_IN_ONE_DAY = 86400L;
    private static final long MINUTES_IN_ONE_HOUR = 60L;
    private static final long HOURS_IN_ONE_DAY = 24L;
    private final long days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int milliseconds;

    public Duration(long days, int hours, int minutes, int seconds, int milliseconds) {
        Preconditions.checkArgument(hours >= -23 && hours <= 23, "hours argument should be in the [-23, 23] range");
        Preconditions.checkArgument(minutes >= -59 && minutes <= 59, "minutes argument should be in the [-59, 59] range");
        Preconditions.checkArgument(seconds >= -59 && seconds <= 59, "seconds argument should be in the [-59, 59] range");
        Preconditions.checkArgument(milliseconds >= 0 && milliseconds <= 999, "milliseconds argument should be in the [0, 999] range");
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public Duration(long duration) {
        this.milliseconds = (int)(duration % 1000L);
        long durationInSeconds = duration / 1000L;
        this.seconds = (int)(durationInSeconds % 60L);
        this.minutes = (int)(durationInSeconds / 60L % 60L);
        this.hours = (int)(durationInSeconds / 3600L % 24L);
        this.days = durationInSeconds / 86400L;
    }

    public long getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public long getTotalMilliseconds() {
        return this.days * 86400L * 1000L + (long)this.hours * 3600L * 1000L + (long)this.minutes * 60L * 1000L + (long)this.seconds * 1000L + (long)this.milliseconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.days != 0L) {
            sb.append(String.format("%02d.", this.days));
        }
        sb.append(String.format("%02d:%02d:%02d", this.hours, this.minutes, this.seconds));
        if (this.milliseconds > 0) {
            sb.append(String.format(".%03d0000", this.milliseconds));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Duration that = (Duration)obj;
        return this.days == that.days && this.hours == that.hours && this.minutes == that.minutes && this.seconds == that.seconds && this.milliseconds == that.milliseconds;
    }

    public int hashCode() {
        return Objects.hash(this.days, this.hours, this.minutes, this.seconds, this.milliseconds);
    }
}

