/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.analytics.Analytics;
import com.microsoft.appcenter.analytics.AuthenticationProvider;
import com.microsoft.appcenter.analytics.EventProperties;
import com.microsoft.appcenter.analytics.PropertyConfigurator;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.one.CommonSchemaLog;
import com.microsoft.appcenter.ingestion.models.one.PartAUtils;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.storage.SharedPreferencesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class AnalyticsTransmissionTarget {
    @VisibleForTesting
    static AuthenticationProvider sAuthenticationProvider;
    private final String mTransmissionTargetToken;
    final AnalyticsTransmissionTarget mParentTarget;
    private final Map<String, AnalyticsTransmissionTarget> mChildrenTargets = new HashMap<String, AnalyticsTransmissionTarget>();
    private final PropertyConfigurator mPropertyConfigurator;
    Context mContext;
    private Channel mChannel;

    AnalyticsTransmissionTarget(@NonNull String transmissionTargetToken, AnalyticsTransmissionTarget parentTarget) {
        this.mTransmissionTargetToken = transmissionTargetToken;
        this.mParentTarget = parentTarget;
        this.mPropertyConfigurator = new PropertyConfigurator(this);
    }

    @WorkerThread
    void initInBackground(Context context, Channel channel) {
        this.mContext = context;
        this.mChannel = channel;
        channel.addListener((Channel.Listener)this.mPropertyConfigurator);
    }

    public static synchronized void addAuthenticationProvider(final AuthenticationProvider authenticationProvider) {
        if (authenticationProvider == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication provider may not be null.");
            return;
        }
        if (authenticationProvider.getType() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication provider type may not be null.");
            return;
        }
        if (authenticationProvider.getTicketKey() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication ticket key may not be null.");
            return;
        }
        if (authenticationProvider.getTokenProvider() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication token provider may not be null.");
            return;
        }
        if (AppCenter.isConfigured()) {
            Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

                @Override
                public void run() {
                    AnalyticsTransmissionTarget.updateProvider(authenticationProvider);
                }
            });
        } else {
            AnalyticsTransmissionTarget.updateProvider(authenticationProvider);
        }
    }

    private static void updateProvider(AuthenticationProvider authenticationProvider) {
        sAuthenticationProvider = authenticationProvider;
        authenticationProvider.acquireTokenAsync();
    }

    public void trackEvent(String name) {
        this.trackEvent(name, (EventProperties)null, 1);
    }

    public void trackEvent(String name, Map<String, String> properties) {
        this.trackEvent(name, properties, 1);
    }

    public void trackEvent(String name, Map<String, String> properties, int flags) {
        EventProperties eventProperties = null;
        if (properties != null) {
            eventProperties = new EventProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                eventProperties.set(entry.getKey(), entry.getValue());
            }
        }
        this.trackEvent(name, eventProperties, flags);
    }

    public void trackEvent(String name, EventProperties properties) {
        this.trackEvent(name, properties, 1);
    }

    public void trackEvent(String name, EventProperties properties, int flags) {
        EventProperties mergedProperties = new EventProperties();
        AnalyticsTransmissionTarget target = this;
        while (target != null) {
            target.getPropertyConfigurator().mergeEventProperties(mergedProperties);
            target = target.mParentTarget;
        }
        if (properties != null) {
            mergedProperties.getProperties().putAll(properties.getProperties());
        } else if (mergedProperties.getProperties().isEmpty()) {
            mergedProperties = null;
        }
        Analytics.trackEvent(name, mergedProperties, this, flags);
    }

    public synchronized AnalyticsTransmissionTarget getTransmissionTarget(String transmissionTargetToken) {
        AnalyticsTransmissionTarget childTarget = this.mChildrenTargets.get(transmissionTargetToken);
        if (childTarget == null) {
            childTarget = new AnalyticsTransmissionTarget(transmissionTargetToken, this);
            this.mChildrenTargets.put(transmissionTargetToken, childTarget);
            final AnalyticsTransmissionTarget finalChildTarget = childTarget;
            Analytics.getInstance().postCommandEvenIfDisabled(new Runnable(){

                @Override
                public void run() {
                    finalChildTarget.initInBackground(AnalyticsTransmissionTarget.this.mContext, AnalyticsTransmissionTarget.this.mChannel);
                }
            });
        }
        return childTarget;
    }

    public AppCenterFuture<Boolean> isEnabledAsync() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)AnalyticsTransmissionTarget.this.isEnabled());
            }
        }, future, false);
        return future;
    }

    public AppCenterFuture<Void> setEnabledAsync(final boolean enabled) {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                if (AnalyticsTransmissionTarget.this.areAncestorsEnabled()) {
                    LinkedList<AnalyticsTransmissionTarget> descendantTargets = new LinkedList<AnalyticsTransmissionTarget>();
                    descendantTargets.add(AnalyticsTransmissionTarget.this);
                    while (!descendantTargets.isEmpty()) {
                        ListIterator<AnalyticsTransmissionTarget> descendantIterator = descendantTargets.listIterator();
                        while (descendantIterator.hasNext()) {
                            AnalyticsTransmissionTarget descendantTarget = (AnalyticsTransmissionTarget)descendantIterator.next();
                            descendantIterator.remove();
                            SharedPreferencesManager.putBoolean((String)descendantTarget.getEnabledPreferenceKey(), (boolean)enabled);
                            for (AnalyticsTransmissionTarget childTarget : descendantTarget.mChildrenTargets.values()) {
                                descendantIterator.add(childTarget);
                            }
                        }
                    }
                } else {
                    AppCenterLog.error((String)"AppCenterAnalytics", (String)"One of the parent transmission target is disabled, cannot change state.");
                }
                future.complete(null);
            }
        }, future, null);
        return future;
    }

    public void pause() {
        Analytics.getInstance().post(new Runnable(){

            @Override
            public void run() {
                AnalyticsTransmissionTarget.this.mChannel.pauseGroup("group_analytics", AnalyticsTransmissionTarget.this.mTransmissionTargetToken);
                AnalyticsTransmissionTarget.this.mChannel.pauseGroup("group_analytics_critical", AnalyticsTransmissionTarget.this.mTransmissionTargetToken);
            }
        });
    }

    public void resume() {
        Analytics.getInstance().post(new Runnable(){

            @Override
            public void run() {
                AnalyticsTransmissionTarget.this.mChannel.resumeGroup("group_analytics", AnalyticsTransmissionTarget.this.mTransmissionTargetToken);
                AnalyticsTransmissionTarget.this.mChannel.resumeGroup("group_analytics_critical", AnalyticsTransmissionTarget.this.mTransmissionTargetToken);
            }
        });
    }

    String getTransmissionTargetToken() {
        return this.mTransmissionTargetToken;
    }

    static Channel.Listener getChannelListener() {
        return new AbstractChannelListener(){

            public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
                AnalyticsTransmissionTarget.addTicketToLog(log);
            }
        };
    }

    private static void addTicketToLog(@NonNull Log log) {
        if (sAuthenticationProvider != null && log instanceof CommonSchemaLog) {
            CommonSchemaLog csLog = (CommonSchemaLog)log;
            String ticketKey = sAuthenticationProvider.getTicketKeyHash();
            csLog.getExt().getProtocol().setTicketKeys(Collections.singletonList(ticketKey));
            sAuthenticationProvider.checkTokenExpiry();
        }
    }

    @NonNull
    private String getEnabledPreferenceKey() {
        return Analytics.getInstance().getEnabledPreferenceKeyPrefix() + PartAUtils.getTargetKey((String)this.mTransmissionTargetToken);
    }

    @WorkerThread
    private boolean isEnabledInStorage() {
        return SharedPreferencesManager.getBoolean((String)this.getEnabledPreferenceKey(), (boolean)true);
    }

    @WorkerThread
    private boolean areAncestorsEnabled() {
        AnalyticsTransmissionTarget target = this.mParentTarget;
        while (target != null) {
            if (!target.isEnabledInStorage()) {
                return false;
            }
            target = target.mParentTarget;
        }
        return true;
    }

    @WorkerThread
    boolean isEnabled() {
        return this.areAncestorsEnabled() && this.isEnabledInStorage();
    }

    public PropertyConfigurator getPropertyConfigurator() {
        return this.mPropertyConfigurator;
    }
}

