/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import java.util.Iterator;

class DelegatingCache
implements ITokenCacheStore {
    private final Context mContext;
    private final ITokenCacheStore mDelegate;

    DelegatingCache(@NonNull Context context, @NonNull ITokenCacheStore delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
    }

    public ITokenCacheStore getDelegateCache() {
        return this.mDelegate;
    }

    @Override
    public TokenCacheItem getItem(String key) {
        return this.mDelegate.getItem(key);
    }

    @Override
    public Iterator<TokenCacheItem> getAll() {
        return this.mDelegate.getAll();
    }

    @Override
    public boolean contains(String key) {
        return this.mDelegate.contains(key);
    }

    @Override
    public void setItem(String key, TokenCacheItem item) {
        this.mDelegate.setItem(key, item);
    }

    @Override
    public void removeItem(String key) {
        this.mDelegate.removeItem(key);
    }

    @Override
    public void removeAll() {
        this.mDelegate.removeAll();
        TokenCacheAccessor.getMsalOAuth2TokenCache(this.mContext).clearAll();
    }
}

